# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDashboardsResult',
    'AwaitableGetDashboardsResult',
    'get_dashboards',
    'get_dashboards_output',
]

@pulumi.output_type
class GetDashboardsResult:
    """
    A collection of values returned by getDashboards.
    """
    def __init__(__self__, dashboards=None, folder_uids=None, id=None, limit=None, org_id=None, tags=None):
        if dashboards and not isinstance(dashboards, list):
            raise TypeError("Expected argument 'dashboards' to be a list")
        pulumi.set(__self__, "dashboards", dashboards)
        if folder_uids and not isinstance(folder_uids, list):
            raise TypeError("Expected argument 'folder_uids' to be a list")
        pulumi.set(__self__, "folder_uids", folder_uids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def dashboards(self) -> Sequence['outputs.GetDashboardsDashboardResult']:
        return pulumi.get(self, "dashboards")

    @_builtins.property
    @pulumi.getter(name="folderUids")
    def folder_uids(self) -> Optional[Sequence[_builtins.str]]:
        """
        UIDs of Grafana folders containing dashboards. Specify to filter for dashboards by folder (eg. `["General"]` for General folder), or leave blank to get all dashboards in all folders.
        """
        return pulumi.get(self, "folder_uids")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        """
        Maximum number of dashboard search results to return. Defaults to `5000`.
        """
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[_builtins.str]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of string Grafana dashboard tags to search for, eg. `["prod"]`. Used only as search input, i.e., attribute value will remain unchanged.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDashboardsResult(GetDashboardsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDashboardsResult(
            dashboards=self.dashboards,
            folder_uids=self.folder_uids,
            id=self.id,
            limit=self.limit,
            org_id=self.org_id,
            tags=self.tags)


def get_dashboards(folder_uids: Optional[Sequence[_builtins.str]] = None,
                   limit: Optional[_builtins.int] = None,
                   org_id: Optional[_builtins.str] = None,
                   tags: Optional[Sequence[_builtins.str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDashboardsResult:
    """
    Datasource for retrieving all dashboards. Specify list of folder IDs to search in for dashboards.

    * [Official documentation](https://grafana.com/docs/grafana/latest/dashboards/)
    * [Folder/Dashboard Search HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/folder_dashboard_search/)
    * [Dashboard HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/dashboard/)


    :param Sequence[_builtins.str] folder_uids: UIDs of Grafana folders containing dashboards. Specify to filter for dashboards by folder (eg. `["General"]` for General folder), or leave blank to get all dashboards in all folders.
    :param _builtins.int limit: Maximum number of dashboard search results to return. Defaults to `5000`.
    :param _builtins.str org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
    :param Sequence[_builtins.str] tags: List of string Grafana dashboard tags to search for, eg. `["prod"]`. Used only as search input, i.e., attribute value will remain unchanged.
    """
    __args__ = dict()
    __args__['folderUids'] = folder_uids
    __args__['limit'] = limit
    __args__['orgId'] = org_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:oss/getDashboards:getDashboards', __args__, opts=opts, typ=GetDashboardsResult).value

    return AwaitableGetDashboardsResult(
        dashboards=pulumi.get(__ret__, 'dashboards'),
        folder_uids=pulumi.get(__ret__, 'folder_uids'),
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        org_id=pulumi.get(__ret__, 'org_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_dashboards_output(folder_uids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                          limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                          org_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          tags: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDashboardsResult]:
    """
    Datasource for retrieving all dashboards. Specify list of folder IDs to search in for dashboards.

    * [Official documentation](https://grafana.com/docs/grafana/latest/dashboards/)
    * [Folder/Dashboard Search HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/folder_dashboard_search/)
    * [Dashboard HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/dashboard/)


    :param Sequence[_builtins.str] folder_uids: UIDs of Grafana folders containing dashboards. Specify to filter for dashboards by folder (eg. `["General"]` for General folder), or leave blank to get all dashboards in all folders.
    :param _builtins.int limit: Maximum number of dashboard search results to return. Defaults to `5000`.
    :param _builtins.str org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
    :param Sequence[_builtins.str] tags: List of string Grafana dashboard tags to search for, eg. `["prod"]`. Used only as search input, i.e., attribute value will remain unchanged.
    """
    __args__ = dict()
    __args__['folderUids'] = folder_uids
    __args__['limit'] = limit
    __args__['orgId'] = org_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:oss/getDashboards:getDashboards', __args__, opts=opts, typ=GetDashboardsResult)
    return __ret__.apply(lambda __response__: GetDashboardsResult(
        dashboards=pulumi.get(__response__, 'dashboards'),
        folder_uids=pulumi.get(__response__, 'folder_uids'),
        id=pulumi.get(__response__, 'id'),
        limit=pulumi.get(__response__, 'limit'),
        org_id=pulumi.get(__response__, 'org_id'),
        tags=pulumi.get(__response__, 'tags')))
