# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OrganizationPreferencesArgs', 'OrganizationPreferences']

@pulumi.input_type
class OrganizationPreferencesArgs:
    def __init__(__self__, *,
                 home_dashboard_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 theme: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 week_start: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OrganizationPreferences resource.
        :param pulumi.Input[_builtins.str] home_dashboard_uid: The Organization home dashboard UID. This is only available in Grafana 9.0+.
        :param pulumi.Input[_builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[_builtins.str] theme: The Organization theme. Available values are `light`, `dark`, `system`, or an empty string for the default.
        :param pulumi.Input[_builtins.str] timezone: The Organization timezone. Available values are `utc`, `browser`, or an empty string for the default.
        :param pulumi.Input[_builtins.str] week_start: The Organization week start day. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default. Defaults to ``.
        """
        if home_dashboard_uid is not None:
            pulumi.set(__self__, "home_dashboard_uid", home_dashboard_uid)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if theme is not None:
            pulumi.set(__self__, "theme", theme)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if week_start is not None:
            pulumi.set(__self__, "week_start", week_start)

    @_builtins.property
    @pulumi.getter(name="homeDashboardUid")
    def home_dashboard_uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Organization home dashboard UID. This is only available in Grafana 9.0+.
        """
        return pulumi.get(self, "home_dashboard_uid")

    @home_dashboard_uid.setter
    def home_dashboard_uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "home_dashboard_uid", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter
    def theme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Organization theme. Available values are `light`, `dark`, `system`, or an empty string for the default.
        """
        return pulumi.get(self, "theme")

    @theme.setter
    def theme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "theme", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Organization timezone. Available values are `utc`, `browser`, or an empty string for the default.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Organization week start day. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default. Defaults to ``.
        """
        return pulumi.get(self, "week_start")

    @week_start.setter
    def week_start(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "week_start", value)


@pulumi.input_type
class _OrganizationPreferencesState:
    def __init__(__self__, *,
                 home_dashboard_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 theme: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 week_start: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationPreferences resources.
        :param pulumi.Input[_builtins.str] home_dashboard_uid: The Organization home dashboard UID. This is only available in Grafana 9.0+.
        :param pulumi.Input[_builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[_builtins.str] theme: The Organization theme. Available values are `light`, `dark`, `system`, or an empty string for the default.
        :param pulumi.Input[_builtins.str] timezone: The Organization timezone. Available values are `utc`, `browser`, or an empty string for the default.
        :param pulumi.Input[_builtins.str] week_start: The Organization week start day. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default. Defaults to ``.
        """
        if home_dashboard_uid is not None:
            pulumi.set(__self__, "home_dashboard_uid", home_dashboard_uid)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if theme is not None:
            pulumi.set(__self__, "theme", theme)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if week_start is not None:
            pulumi.set(__self__, "week_start", week_start)

    @_builtins.property
    @pulumi.getter(name="homeDashboardUid")
    def home_dashboard_uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Organization home dashboard UID. This is only available in Grafana 9.0+.
        """
        return pulumi.get(self, "home_dashboard_uid")

    @home_dashboard_uid.setter
    def home_dashboard_uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "home_dashboard_uid", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter
    def theme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Organization theme. Available values are `light`, `dark`, `system`, or an empty string for the default.
        """
        return pulumi.get(self, "theme")

    @theme.setter
    def theme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "theme", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Organization timezone. Available values are `utc`, `browser`, or an empty string for the default.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Organization week start day. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default. Defaults to ``.
        """
        return pulumi.get(self, "week_start")

    @week_start.setter
    def week_start(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "week_start", value)


@pulumi.type_token("grafana:oss/organizationPreferences:OrganizationPreferences")
class OrganizationPreferences(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 home_dashboard_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 theme: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 week_start: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        * [Official documentation](https://grafana.com/docs/grafana/latest/administration/organization-management/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/preferences/#get-current-org-prefs)

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test = grafana.oss.OrganizationPreferences("test",
            theme="light",
            timezone="utc",
            week_start="sunday")
        ```

        ## Import

        ```sh
        $ pulumi import grafana:oss/organizationPreferences:OrganizationPreferences name "{{ orgID }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] home_dashboard_uid: The Organization home dashboard UID. This is only available in Grafana 9.0+.
        :param pulumi.Input[_builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[_builtins.str] theme: The Organization theme. Available values are `light`, `dark`, `system`, or an empty string for the default.
        :param pulumi.Input[_builtins.str] timezone: The Organization timezone. Available values are `utc`, `browser`, or an empty string for the default.
        :param pulumi.Input[_builtins.str] week_start: The Organization week start day. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default. Defaults to ``.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[OrganizationPreferencesArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        * [Official documentation](https://grafana.com/docs/grafana/latest/administration/organization-management/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/preferences/#get-current-org-prefs)

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test = grafana.oss.OrganizationPreferences("test",
            theme="light",
            timezone="utc",
            week_start="sunday")
        ```

        ## Import

        ```sh
        $ pulumi import grafana:oss/organizationPreferences:OrganizationPreferences name "{{ orgID }}"
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationPreferencesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationPreferencesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 home_dashboard_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 theme: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 week_start: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationPreferencesArgs.__new__(OrganizationPreferencesArgs)

            __props__.__dict__["home_dashboard_uid"] = home_dashboard_uid
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["theme"] = theme
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["week_start"] = week_start
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="grafana:index/organizationPreferences:OrganizationPreferences")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(OrganizationPreferences, __self__).__init__(
            'grafana:oss/organizationPreferences:OrganizationPreferences',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            home_dashboard_uid: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            theme: Optional[pulumi.Input[_builtins.str]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            week_start: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationPreferences':
        """
        Get an existing OrganizationPreferences resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] home_dashboard_uid: The Organization home dashboard UID. This is only available in Grafana 9.0+.
        :param pulumi.Input[_builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[_builtins.str] theme: The Organization theme. Available values are `light`, `dark`, `system`, or an empty string for the default.
        :param pulumi.Input[_builtins.str] timezone: The Organization timezone. Available values are `utc`, `browser`, or an empty string for the default.
        :param pulumi.Input[_builtins.str] week_start: The Organization week start day. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default. Defaults to ``.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationPreferencesState.__new__(_OrganizationPreferencesState)

        __props__.__dict__["home_dashboard_uid"] = home_dashboard_uid
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["theme"] = theme
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["week_start"] = week_start
        return OrganizationPreferences(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="homeDashboardUid")
    def home_dashboard_uid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Organization home dashboard UID. This is only available in Grafana 9.0+.
        """
        return pulumi.get(self, "home_dashboard_uid")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter
    def theme(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Organization theme. Available values are `light`, `dark`, `system`, or an empty string for the default.
        """
        return pulumi.get(self, "theme")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Organization timezone. Available values are `utc`, `browser`, or an empty string for the default.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Organization week start day. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default. Defaults to ``.
        """
        return pulumi.get(self, "week_start")

