# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PlaylistArgs', 'Playlist']

@pulumi.input_type
class PlaylistArgs:
    def __init__(__self__, *,
                 interval: pulumi.Input[_builtins.str],
                 items: pulumi.Input[Sequence[pulumi.Input['PlaylistItemArgs']]],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Playlist resource.
        :param pulumi.Input[_builtins.str] name: The name of the playlist.
        :param pulumi.Input[_builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "items", items)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input['PlaylistItemArgs']]]:
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input['PlaylistItemArgs']]]):
        pulumi.set(self, "items", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the playlist.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)


@pulumi.input_type
class _PlaylistState:
    def __init__(__self__, *,
                 interval: Optional[pulumi.Input[_builtins.str]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['PlaylistItemArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Playlist resources.
        :param pulumi.Input[_builtins.str] name: The name of the playlist.
        :param pulumi.Input[_builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlaylistItemArgs']]]]:
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlaylistItemArgs']]]]):
        pulumi.set(self, "items", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the playlist.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)


@pulumi.type_token("grafana:oss/playlist:Playlist")
class Playlist(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 interval: Optional[pulumi.Input[_builtins.str]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlaylistItemArgs', 'PlaylistItemArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        * [Official documentation](https://grafana.com/docs/grafana/latest/dashboards/create-manage-playlists/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/playlist/)

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test = grafana.oss.Playlist("test",
            name="My Playlist!",
            interval="5m",
            items=[
                {
                    "order": 2,
                    "type": "dashboard_by_tag",
                    "value": "terraform",
                },
                {
                    "order": 1,
                    "type": "dashboard_by_uid",
                    "value": "cIBgcSjkk",
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import grafana:oss/playlist:Playlist name "{{ uid }}"
        ```

        ```sh
        $ pulumi import grafana:oss/playlist:Playlist name "{{ orgID }}:{{ uid }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the playlist.
        :param pulumi.Input[_builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PlaylistArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        * [Official documentation](https://grafana.com/docs/grafana/latest/dashboards/create-manage-playlists/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/playlist/)

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test = grafana.oss.Playlist("test",
            name="My Playlist!",
            interval="5m",
            items=[
                {
                    "order": 2,
                    "type": "dashboard_by_tag",
                    "value": "terraform",
                },
                {
                    "order": 1,
                    "type": "dashboard_by_uid",
                    "value": "cIBgcSjkk",
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import grafana:oss/playlist:Playlist name "{{ uid }}"
        ```

        ```sh
        $ pulumi import grafana:oss/playlist:Playlist name "{{ orgID }}:{{ uid }}"
        ```

        :param str resource_name: The name of the resource.
        :param PlaylistArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PlaylistArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 interval: Optional[pulumi.Input[_builtins.str]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlaylistItemArgs', 'PlaylistItemArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PlaylistArgs.__new__(PlaylistArgs)

            if interval is None and not opts.urn:
                raise TypeError("Missing required property 'interval'")
            __props__.__dict__["interval"] = interval
            if items is None and not opts.urn:
                raise TypeError("Missing required property 'items'")
            __props__.__dict__["items"] = items
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="grafana:index/playlist:Playlist")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Playlist, __self__).__init__(
            'grafana:oss/playlist:Playlist',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            interval: Optional[pulumi.Input[_builtins.str]] = None,
            items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlaylistItemArgs', 'PlaylistItemArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Playlist':
        """
        Get an existing Playlist resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the playlist.
        :param pulumi.Input[_builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PlaylistState.__new__(_PlaylistState)

        __props__.__dict__["interval"] = interval
        __props__.__dict__["items"] = items
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        return Playlist(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def items(self) -> pulumi.Output[Sequence['outputs.PlaylistItem']]:
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the playlist.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

