# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SLOArgs', 'SLO']

@pulumi.input_type
class SLOArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 destination_datasource: pulumi.Input['SLODestinationDatasourceArgs'],
                 objectives: pulumi.Input[Sequence[pulumi.Input['SLOObjectiveArgs']]],
                 queries: pulumi.Input[Sequence[pulumi.Input['SLOQueryArgs']]],
                 alerting: Optional[pulumi.Input['SLOAlertingArgs']] = None,
                 folder_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['SLOLabelArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 search_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SLO resource.
        :param pulumi.Input[_builtins.str] description: Description is a free-text field that can provide more context to an SLO.
        :param pulumi.Input['SLODestinationDatasourceArgs'] destination_datasource: Destination Datasource sets the datasource defined for an SLO
        :param pulumi.Input[Sequence[pulumi.Input['SLOObjectiveArgs']]] objectives: Over each rolling time window, the remaining error budget will be calculated, and separate alerts can be generated for each time window based on the SLO burn rate or remaining error budget.
        :param pulumi.Input[Sequence[pulumi.Input['SLOQueryArgs']]] queries: Query describes the indicator that will be measured against the objective. Freeform Query types are currently supported.
        :param pulumi.Input['SLOAlertingArgs'] alerting: Configures the alerting rules that will be generated for each
               			time window associated with the SLO. Grafana SLOs can generate
               			alerts when the short-term error budget burn is very high, the
               			long-term error budget burn rate is high, or when the remaining
               			error budget is below a certain threshold. Annotations and Labels support templating.
        :param pulumi.Input[_builtins.str] folder_uid: UID for the SLO folder
        :param pulumi.Input[Sequence[pulumi.Input['SLOLabelArgs']]] labels: Additional labels that will be attached to all metrics generated from the query. These labels are useful for grouping SLOs in dashboard views that you create by hand. Labels must adhere to Prometheus label name schema - "^[a-zA-Z*][a-zA-Z0-9*]*$"
        :param pulumi.Input[_builtins.str] name: Name should be a short description of your indicator. Consider names like "API Availability"
        :param pulumi.Input[_builtins.str] search_expression: The name of a search expression in Grafana Asserts. This is used in the SLO UI to open the Asserts RCA workbench and in alerts to link to the RCA workbench.
        :param pulumi.Input[_builtins.str] uuid: UUID for the SLO. Custom UUIDs can be set. If not provided, a random UUID will be generated by the API.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination_datasource", destination_datasource)
        pulumi.set(__self__, "objectives", objectives)
        pulumi.set(__self__, "queries", queries)
        if alerting is not None:
            pulumi.set(__self__, "alerting", alerting)
        if folder_uid is not None:
            pulumi.set(__self__, "folder_uid", folder_uid)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if search_expression is not None:
            pulumi.set(__self__, "search_expression", search_expression)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        Description is a free-text field that can provide more context to an SLO.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationDatasource")
    def destination_datasource(self) -> pulumi.Input['SLODestinationDatasourceArgs']:
        """
        Destination Datasource sets the datasource defined for an SLO
        """
        return pulumi.get(self, "destination_datasource")

    @destination_datasource.setter
    def destination_datasource(self, value: pulumi.Input['SLODestinationDatasourceArgs']):
        pulumi.set(self, "destination_datasource", value)

    @_builtins.property
    @pulumi.getter
    def objectives(self) -> pulumi.Input[Sequence[pulumi.Input['SLOObjectiveArgs']]]:
        """
        Over each rolling time window, the remaining error budget will be calculated, and separate alerts can be generated for each time window based on the SLO burn rate or remaining error budget.
        """
        return pulumi.get(self, "objectives")

    @objectives.setter
    def objectives(self, value: pulumi.Input[Sequence[pulumi.Input['SLOObjectiveArgs']]]):
        pulumi.set(self, "objectives", value)

    @_builtins.property
    @pulumi.getter
    def queries(self) -> pulumi.Input[Sequence[pulumi.Input['SLOQueryArgs']]]:
        """
        Query describes the indicator that will be measured against the objective. Freeform Query types are currently supported.
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: pulumi.Input[Sequence[pulumi.Input['SLOQueryArgs']]]):
        pulumi.set(self, "queries", value)

    @_builtins.property
    @pulumi.getter
    def alerting(self) -> Optional[pulumi.Input['SLOAlertingArgs']]:
        """
        Configures the alerting rules that will be generated for each
        			time window associated with the SLO. Grafana SLOs can generate
        			alerts when the short-term error budget burn is very high, the
        			long-term error budget burn rate is high, or when the remaining
        			error budget is below a certain threshold. Annotations and Labels support templating.
        """
        return pulumi.get(self, "alerting")

    @alerting.setter
    def alerting(self, value: Optional[pulumi.Input['SLOAlertingArgs']]):
        pulumi.set(self, "alerting", value)

    @_builtins.property
    @pulumi.getter(name="folderUid")
    def folder_uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UID for the SLO folder
        """
        return pulumi.get(self, "folder_uid")

    @folder_uid.setter
    def folder_uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_uid", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SLOLabelArgs']]]]:
        """
        Additional labels that will be attached to all metrics generated from the query. These labels are useful for grouping SLOs in dashboard views that you create by hand. Labels must adhere to Prometheus label name schema - "^[a-zA-Z*][a-zA-Z0-9*]*$"
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SLOLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name should be a short description of your indicator. Consider names like "API Availability"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="searchExpression")
    def search_expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a search expression in Grafana Asserts. This is used in the SLO UI to open the Asserts RCA workbench and in alerts to link to the RCA workbench.
        """
        return pulumi.get(self, "search_expression")

    @search_expression.setter
    def search_expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "search_expression", value)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID for the SLO. Custom UUIDs can be set. If not provided, a random UUID will be generated by the API.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uuid", value)


@pulumi.input_type
class _SLOState:
    def __init__(__self__, *,
                 alerting: Optional[pulumi.Input['SLOAlertingArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_datasource: Optional[pulumi.Input['SLODestinationDatasourceArgs']] = None,
                 folder_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['SLOLabelArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 objectives: Optional[pulumi.Input[Sequence[pulumi.Input['SLOObjectiveArgs']]]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input['SLOQueryArgs']]]] = None,
                 search_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SLO resources.
        :param pulumi.Input['SLOAlertingArgs'] alerting: Configures the alerting rules that will be generated for each
               			time window associated with the SLO. Grafana SLOs can generate
               			alerts when the short-term error budget burn is very high, the
               			long-term error budget burn rate is high, or when the remaining
               			error budget is below a certain threshold. Annotations and Labels support templating.
        :param pulumi.Input[_builtins.str] description: Description is a free-text field that can provide more context to an SLO.
        :param pulumi.Input['SLODestinationDatasourceArgs'] destination_datasource: Destination Datasource sets the datasource defined for an SLO
        :param pulumi.Input[_builtins.str] folder_uid: UID for the SLO folder
        :param pulumi.Input[Sequence[pulumi.Input['SLOLabelArgs']]] labels: Additional labels that will be attached to all metrics generated from the query. These labels are useful for grouping SLOs in dashboard views that you create by hand. Labels must adhere to Prometheus label name schema - "^[a-zA-Z*][a-zA-Z0-9*]*$"
        :param pulumi.Input[_builtins.str] name: Name should be a short description of your indicator. Consider names like "API Availability"
        :param pulumi.Input[Sequence[pulumi.Input['SLOObjectiveArgs']]] objectives: Over each rolling time window, the remaining error budget will be calculated, and separate alerts can be generated for each time window based on the SLO burn rate or remaining error budget.
        :param pulumi.Input[Sequence[pulumi.Input['SLOQueryArgs']]] queries: Query describes the indicator that will be measured against the objective. Freeform Query types are currently supported.
        :param pulumi.Input[_builtins.str] search_expression: The name of a search expression in Grafana Asserts. This is used in the SLO UI to open the Asserts RCA workbench and in alerts to link to the RCA workbench.
        :param pulumi.Input[_builtins.str] uuid: UUID for the SLO. Custom UUIDs can be set. If not provided, a random UUID will be generated by the API.
        """
        if alerting is not None:
            pulumi.set(__self__, "alerting", alerting)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_datasource is not None:
            pulumi.set(__self__, "destination_datasource", destination_datasource)
        if folder_uid is not None:
            pulumi.set(__self__, "folder_uid", folder_uid)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if objectives is not None:
            pulumi.set(__self__, "objectives", objectives)
        if queries is not None:
            pulumi.set(__self__, "queries", queries)
        if search_expression is not None:
            pulumi.set(__self__, "search_expression", search_expression)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def alerting(self) -> Optional[pulumi.Input['SLOAlertingArgs']]:
        """
        Configures the alerting rules that will be generated for each
        			time window associated with the SLO. Grafana SLOs can generate
        			alerts when the short-term error budget burn is very high, the
        			long-term error budget burn rate is high, or when the remaining
        			error budget is below a certain threshold. Annotations and Labels support templating.
        """
        return pulumi.get(self, "alerting")

    @alerting.setter
    def alerting(self, value: Optional[pulumi.Input['SLOAlertingArgs']]):
        pulumi.set(self, "alerting", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description is a free-text field that can provide more context to an SLO.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationDatasource")
    def destination_datasource(self) -> Optional[pulumi.Input['SLODestinationDatasourceArgs']]:
        """
        Destination Datasource sets the datasource defined for an SLO
        """
        return pulumi.get(self, "destination_datasource")

    @destination_datasource.setter
    def destination_datasource(self, value: Optional[pulumi.Input['SLODestinationDatasourceArgs']]):
        pulumi.set(self, "destination_datasource", value)

    @_builtins.property
    @pulumi.getter(name="folderUid")
    def folder_uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UID for the SLO folder
        """
        return pulumi.get(self, "folder_uid")

    @folder_uid.setter
    def folder_uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_uid", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SLOLabelArgs']]]]:
        """
        Additional labels that will be attached to all metrics generated from the query. These labels are useful for grouping SLOs in dashboard views that you create by hand. Labels must adhere to Prometheus label name schema - "^[a-zA-Z*][a-zA-Z0-9*]*$"
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SLOLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name should be a short description of your indicator. Consider names like "API Availability"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def objectives(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SLOObjectiveArgs']]]]:
        """
        Over each rolling time window, the remaining error budget will be calculated, and separate alerts can be generated for each time window based on the SLO burn rate or remaining error budget.
        """
        return pulumi.get(self, "objectives")

    @objectives.setter
    def objectives(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SLOObjectiveArgs']]]]):
        pulumi.set(self, "objectives", value)

    @_builtins.property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SLOQueryArgs']]]]:
        """
        Query describes the indicator that will be measured against the objective. Freeform Query types are currently supported.
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SLOQueryArgs']]]]):
        pulumi.set(self, "queries", value)

    @_builtins.property
    @pulumi.getter(name="searchExpression")
    def search_expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a search expression in Grafana Asserts. This is used in the SLO UI to open the Asserts RCA workbench and in alerts to link to the RCA workbench.
        """
        return pulumi.get(self, "search_expression")

    @search_expression.setter
    def search_expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "search_expression", value)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID for the SLO. Custom UUIDs can be set. If not provided, a random UUID will be generated by the API.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uuid", value)


@pulumi.type_token("grafana:slo/sLO:SLO")
class SLO(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerting: Optional[pulumi.Input[Union['SLOAlertingArgs', 'SLOAlertingArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_datasource: Optional[pulumi.Input[Union['SLODestinationDatasourceArgs', 'SLODestinationDatasourceArgsDict']]] = None,
                 folder_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SLOLabelArgs', 'SLOLabelArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 objectives: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SLOObjectiveArgs', 'SLOObjectiveArgsDict']]]]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SLOQueryArgs', 'SLOQueryArgsDict']]]]] = None,
                 search_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource manages Grafana SLOs.

        * [Official documentation](https://grafana.com/docs/grafana-cloud/alerting-and-irm/slo/)
        * [API documentation](https://grafana.com/docs/grafana-cloud/alerting-and-irm/slo/api/)
        * [Additional Information On Alerting Rule Annotations and Labels](https://prometheus.io/docs/prometheus/latest/configuration/alerting_rules/#templating/)

        ## Example Usage

        ### Ratio

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        ratio = grafana.slo.SLO("ratio",
            name="Terraform Testing - Ratio Query",
            description="Terraform Description - Ratio Query",
            queries=[{
                "ratio": {
                    "success_metric": "kubelet_http_requests_total{status!~\\"5..\\"}",
                    "total_metric": "kubelet_http_requests_total",
                    "group_by_labels": [
                        "job",
                        "instance",
                    ],
                },
                "type": "ratio",
            }],
            objectives=[{
                "value": 0.995,
                "window": "30d",
            }],
            destination_datasource={
                "uid": "grafanacloud-prom",
            },
            labels=[{
                "key": "slo",
                "value": "terraform",
            }],
            alerting={
                "fastburn": {
                    "annotations": [
                        {
                            "key": "name",
                            "value": "SLO Burn Rate Very High",
                        },
                        {
                            "key": "description",
                            "value": "Error budget is burning too fast",
                        },
                    ],
                },
                "slowburn": {
                    "annotations": [
                        {
                            "key": "name",
                            "value": "SLO Burn Rate High",
                        },
                        {
                            "key": "description",
                            "value": "Error budget is burning too fast",
                        },
                    ],
                },
            })
        ```

        ### Advanced

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test = grafana.slo.SLO("test",
            name="Terraform Testing",
            description="Terraform Description",
            queries=[{
                "freeform": {
                    "query": "sum(rate(apiserver_request_total{code!=\\"500\\"}[$__rate_interval])) / sum(rate(apiserver_request_total[$__rate_interval]))",
                },
                "type": "freeform",
            }],
            objectives=[{
                "value": 0.995,
                "window": "30d",
            }],
            destination_datasource={
                "uid": "grafanacloud-prom",
            },
            labels=[{
                "key": "slo",
                "value": "terraform",
            }],
            alerting={
                "fastburn": {
                    "annotations": [
                        {
                            "key": "name",
                            "value": "SLO Burn Rate Very High",
                        },
                        {
                            "key": "description",
                            "value": "Error budget is burning too fast",
                        },
                    ],
                },
                "slowburn": {
                    "annotations": [
                        {
                            "key": "name",
                            "value": "SLO Burn Rate High",
                        },
                        {
                            "key": "description",
                            "value": "Error budget is burning too fast",
                        },
                    ],
                },
            })
        ```

        ### Grafana Queries - Any supported datasource

        Grafana Queries use the grafana_queries field. It expects a JSON string list of valid grafana query JSON objects, the same as you'll find assigned to a Grafana Dashboard panel `targets` field.

        ```python
        import pulumi
        import json
        import pulumiverse_grafana as grafana

        test = grafana.slo.SLO("test",
            name="Terraform Testing",
            description="Terraform Description",
            queries=[{
                "grafana_queries": {
                    "grafana_queries": json.dumps([
                        {
                            "datasource": {
                                "type": "graphite",
                                "uid": "datasource-uid",
                            },
                            "refId": "Success",
                            "target": "groupByNode(perSecond(web.*.http.2xx_success.*.*), 3, 'avg')",
                        },
                        {
                            "datasource": {
                                "type": "graphite",
                                "uid": "datasource-uid",
                            },
                            "refId": "Total",
                            "target": "groupByNode(perSecond(web.*.http.5xx_errors.*.*), 3, 'avg')",
                        },
                        {
                            "datasource": {
                                "type": "__expr__",
                                "uid": "__expr__",
                            },
                            "expression": "$Success / $Total",
                            "refId": "Expression",
                            "type": "math",
                        },
                    ]),
                },
                "type": "grafana_queries",
            }],
            destination_datasource={
                "uid": "grafanacloud-prom",
            },
            objectives=[{
                "value": 0.995,
                "window": "30d",
            }],
            labels=[{
                "key": "slo",
                "value": "terraform",
            }],
            alerting={
                "fastburn": {
                    "annotations": [
                        {
                            "key": "name",
                            "value": "SLO Burn Rate Very High",
                        },
                        {
                            "key": "description",
                            "value": "Error budget is burning too fast",
                        },
                    ],
                },
                "slowburn": {
                    "annotations": [
                        {
                            "key": "name",
                            "value": "SLO Burn Rate High",
                        },
                        {
                            "key": "description",
                            "value": "Error budget is burning too fast",
                        },
                    ],
                },
            })
        ```

        For a complete list, see [supported data sources](https://grafana.com/docs/grafana-cloud/alerting-and-irm/slo/set-up/additionaldatasources/#supported-data-sources).

        For additional help with SLOs, view our [documentation](https://grafana.com/docs/grafana-cloud/alerting-and-irm/slo/).

        ## Import

        ```sh
        $ pulumi import grafana:slo/sLO:SLO name "{{ uuid }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SLOAlertingArgs', 'SLOAlertingArgsDict']] alerting: Configures the alerting rules that will be generated for each
               			time window associated with the SLO. Grafana SLOs can generate
               			alerts when the short-term error budget burn is very high, the
               			long-term error budget burn rate is high, or when the remaining
               			error budget is below a certain threshold. Annotations and Labels support templating.
        :param pulumi.Input[_builtins.str] description: Description is a free-text field that can provide more context to an SLO.
        :param pulumi.Input[Union['SLODestinationDatasourceArgs', 'SLODestinationDatasourceArgsDict']] destination_datasource: Destination Datasource sets the datasource defined for an SLO
        :param pulumi.Input[_builtins.str] folder_uid: UID for the SLO folder
        :param pulumi.Input[Sequence[pulumi.Input[Union['SLOLabelArgs', 'SLOLabelArgsDict']]]] labels: Additional labels that will be attached to all metrics generated from the query. These labels are useful for grouping SLOs in dashboard views that you create by hand. Labels must adhere to Prometheus label name schema - "^[a-zA-Z*][a-zA-Z0-9*]*$"
        :param pulumi.Input[_builtins.str] name: Name should be a short description of your indicator. Consider names like "API Availability"
        :param pulumi.Input[Sequence[pulumi.Input[Union['SLOObjectiveArgs', 'SLOObjectiveArgsDict']]]] objectives: Over each rolling time window, the remaining error budget will be calculated, and separate alerts can be generated for each time window based on the SLO burn rate or remaining error budget.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SLOQueryArgs', 'SLOQueryArgsDict']]]] queries: Query describes the indicator that will be measured against the objective. Freeform Query types are currently supported.
        :param pulumi.Input[_builtins.str] search_expression: The name of a search expression in Grafana Asserts. This is used in the SLO UI to open the Asserts RCA workbench and in alerts to link to the RCA workbench.
        :param pulumi.Input[_builtins.str] uuid: UUID for the SLO. Custom UUIDs can be set. If not provided, a random UUID will be generated by the API.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SLOArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource manages Grafana SLOs.

        * [Official documentation](https://grafana.com/docs/grafana-cloud/alerting-and-irm/slo/)
        * [API documentation](https://grafana.com/docs/grafana-cloud/alerting-and-irm/slo/api/)
        * [Additional Information On Alerting Rule Annotations and Labels](https://prometheus.io/docs/prometheus/latest/configuration/alerting_rules/#templating/)

        ## Example Usage

        ### Ratio

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        ratio = grafana.slo.SLO("ratio",
            name="Terraform Testing - Ratio Query",
            description="Terraform Description - Ratio Query",
            queries=[{
                "ratio": {
                    "success_metric": "kubelet_http_requests_total{status!~\\"5..\\"}",
                    "total_metric": "kubelet_http_requests_total",
                    "group_by_labels": [
                        "job",
                        "instance",
                    ],
                },
                "type": "ratio",
            }],
            objectives=[{
                "value": 0.995,
                "window": "30d",
            }],
            destination_datasource={
                "uid": "grafanacloud-prom",
            },
            labels=[{
                "key": "slo",
                "value": "terraform",
            }],
            alerting={
                "fastburn": {
                    "annotations": [
                        {
                            "key": "name",
                            "value": "SLO Burn Rate Very High",
                        },
                        {
                            "key": "description",
                            "value": "Error budget is burning too fast",
                        },
                    ],
                },
                "slowburn": {
                    "annotations": [
                        {
                            "key": "name",
                            "value": "SLO Burn Rate High",
                        },
                        {
                            "key": "description",
                            "value": "Error budget is burning too fast",
                        },
                    ],
                },
            })
        ```

        ### Advanced

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test = grafana.slo.SLO("test",
            name="Terraform Testing",
            description="Terraform Description",
            queries=[{
                "freeform": {
                    "query": "sum(rate(apiserver_request_total{code!=\\"500\\"}[$__rate_interval])) / sum(rate(apiserver_request_total[$__rate_interval]))",
                },
                "type": "freeform",
            }],
            objectives=[{
                "value": 0.995,
                "window": "30d",
            }],
            destination_datasource={
                "uid": "grafanacloud-prom",
            },
            labels=[{
                "key": "slo",
                "value": "terraform",
            }],
            alerting={
                "fastburn": {
                    "annotations": [
                        {
                            "key": "name",
                            "value": "SLO Burn Rate Very High",
                        },
                        {
                            "key": "description",
                            "value": "Error budget is burning too fast",
                        },
                    ],
                },
                "slowburn": {
                    "annotations": [
                        {
                            "key": "name",
                            "value": "SLO Burn Rate High",
                        },
                        {
                            "key": "description",
                            "value": "Error budget is burning too fast",
                        },
                    ],
                },
            })
        ```

        ### Grafana Queries - Any supported datasource

        Grafana Queries use the grafana_queries field. It expects a JSON string list of valid grafana query JSON objects, the same as you'll find assigned to a Grafana Dashboard panel `targets` field.

        ```python
        import pulumi
        import json
        import pulumiverse_grafana as grafana

        test = grafana.slo.SLO("test",
            name="Terraform Testing",
            description="Terraform Description",
            queries=[{
                "grafana_queries": {
                    "grafana_queries": json.dumps([
                        {
                            "datasource": {
                                "type": "graphite",
                                "uid": "datasource-uid",
                            },
                            "refId": "Success",
                            "target": "groupByNode(perSecond(web.*.http.2xx_success.*.*), 3, 'avg')",
                        },
                        {
                            "datasource": {
                                "type": "graphite",
                                "uid": "datasource-uid",
                            },
                            "refId": "Total",
                            "target": "groupByNode(perSecond(web.*.http.5xx_errors.*.*), 3, 'avg')",
                        },
                        {
                            "datasource": {
                                "type": "__expr__",
                                "uid": "__expr__",
                            },
                            "expression": "$Success / $Total",
                            "refId": "Expression",
                            "type": "math",
                        },
                    ]),
                },
                "type": "grafana_queries",
            }],
            destination_datasource={
                "uid": "grafanacloud-prom",
            },
            objectives=[{
                "value": 0.995,
                "window": "30d",
            }],
            labels=[{
                "key": "slo",
                "value": "terraform",
            }],
            alerting={
                "fastburn": {
                    "annotations": [
                        {
                            "key": "name",
                            "value": "SLO Burn Rate Very High",
                        },
                        {
                            "key": "description",
                            "value": "Error budget is burning too fast",
                        },
                    ],
                },
                "slowburn": {
                    "annotations": [
                        {
                            "key": "name",
                            "value": "SLO Burn Rate High",
                        },
                        {
                            "key": "description",
                            "value": "Error budget is burning too fast",
                        },
                    ],
                },
            })
        ```

        For a complete list, see [supported data sources](https://grafana.com/docs/grafana-cloud/alerting-and-irm/slo/set-up/additionaldatasources/#supported-data-sources).

        For additional help with SLOs, view our [documentation](https://grafana.com/docs/grafana-cloud/alerting-and-irm/slo/).

        ## Import

        ```sh
        $ pulumi import grafana:slo/sLO:SLO name "{{ uuid }}"
        ```

        :param str resource_name: The name of the resource.
        :param SLOArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SLOArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerting: Optional[pulumi.Input[Union['SLOAlertingArgs', 'SLOAlertingArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_datasource: Optional[pulumi.Input[Union['SLODestinationDatasourceArgs', 'SLODestinationDatasourceArgsDict']]] = None,
                 folder_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SLOLabelArgs', 'SLOLabelArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 objectives: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SLOObjectiveArgs', 'SLOObjectiveArgsDict']]]]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SLOQueryArgs', 'SLOQueryArgsDict']]]]] = None,
                 search_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SLOArgs.__new__(SLOArgs)

            __props__.__dict__["alerting"] = alerting
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if destination_datasource is None and not opts.urn:
                raise TypeError("Missing required property 'destination_datasource'")
            __props__.__dict__["destination_datasource"] = destination_datasource
            __props__.__dict__["folder_uid"] = folder_uid
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            if objectives is None and not opts.urn:
                raise TypeError("Missing required property 'objectives'")
            __props__.__dict__["objectives"] = objectives
            if queries is None and not opts.urn:
                raise TypeError("Missing required property 'queries'")
            __props__.__dict__["queries"] = queries
            __props__.__dict__["search_expression"] = search_expression
            __props__.__dict__["uuid"] = uuid
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="grafana:index/sLO:SLO")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(SLO, __self__).__init__(
            'grafana:slo/sLO:SLO',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alerting: Optional[pulumi.Input[Union['SLOAlertingArgs', 'SLOAlertingArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_datasource: Optional[pulumi.Input[Union['SLODestinationDatasourceArgs', 'SLODestinationDatasourceArgsDict']]] = None,
            folder_uid: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SLOLabelArgs', 'SLOLabelArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            objectives: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SLOObjectiveArgs', 'SLOObjectiveArgsDict']]]]] = None,
            queries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SLOQueryArgs', 'SLOQueryArgsDict']]]]] = None,
            search_expression: Optional[pulumi.Input[_builtins.str]] = None,
            uuid: Optional[pulumi.Input[_builtins.str]] = None) -> 'SLO':
        """
        Get an existing SLO resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SLOAlertingArgs', 'SLOAlertingArgsDict']] alerting: Configures the alerting rules that will be generated for each
               			time window associated with the SLO. Grafana SLOs can generate
               			alerts when the short-term error budget burn is very high, the
               			long-term error budget burn rate is high, or when the remaining
               			error budget is below a certain threshold. Annotations and Labels support templating.
        :param pulumi.Input[_builtins.str] description: Description is a free-text field that can provide more context to an SLO.
        :param pulumi.Input[Union['SLODestinationDatasourceArgs', 'SLODestinationDatasourceArgsDict']] destination_datasource: Destination Datasource sets the datasource defined for an SLO
        :param pulumi.Input[_builtins.str] folder_uid: UID for the SLO folder
        :param pulumi.Input[Sequence[pulumi.Input[Union['SLOLabelArgs', 'SLOLabelArgsDict']]]] labels: Additional labels that will be attached to all metrics generated from the query. These labels are useful for grouping SLOs in dashboard views that you create by hand. Labels must adhere to Prometheus label name schema - "^[a-zA-Z*][a-zA-Z0-9*]*$"
        :param pulumi.Input[_builtins.str] name: Name should be a short description of your indicator. Consider names like "API Availability"
        :param pulumi.Input[Sequence[pulumi.Input[Union['SLOObjectiveArgs', 'SLOObjectiveArgsDict']]]] objectives: Over each rolling time window, the remaining error budget will be calculated, and separate alerts can be generated for each time window based on the SLO burn rate or remaining error budget.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SLOQueryArgs', 'SLOQueryArgsDict']]]] queries: Query describes the indicator that will be measured against the objective. Freeform Query types are currently supported.
        :param pulumi.Input[_builtins.str] search_expression: The name of a search expression in Grafana Asserts. This is used in the SLO UI to open the Asserts RCA workbench and in alerts to link to the RCA workbench.
        :param pulumi.Input[_builtins.str] uuid: UUID for the SLO. Custom UUIDs can be set. If not provided, a random UUID will be generated by the API.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SLOState.__new__(_SLOState)

        __props__.__dict__["alerting"] = alerting
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_datasource"] = destination_datasource
        __props__.__dict__["folder_uid"] = folder_uid
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["objectives"] = objectives
        __props__.__dict__["queries"] = queries
        __props__.__dict__["search_expression"] = search_expression
        __props__.__dict__["uuid"] = uuid
        return SLO(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def alerting(self) -> pulumi.Output[Optional['outputs.SLOAlerting']]:
        """
        Configures the alerting rules that will be generated for each
        			time window associated with the SLO. Grafana SLOs can generate
        			alerts when the short-term error budget burn is very high, the
        			long-term error budget burn rate is high, or when the remaining
        			error budget is below a certain threshold. Annotations and Labels support templating.
        """
        return pulumi.get(self, "alerting")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description is a free-text field that can provide more context to an SLO.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationDatasource")
    def destination_datasource(self) -> pulumi.Output['outputs.SLODestinationDatasource']:
        """
        Destination Datasource sets the datasource defined for an SLO
        """
        return pulumi.get(self, "destination_datasource")

    @_builtins.property
    @pulumi.getter(name="folderUid")
    def folder_uid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        UID for the SLO folder
        """
        return pulumi.get(self, "folder_uid")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.SLOLabel']]]:
        """
        Additional labels that will be attached to all metrics generated from the query. These labels are useful for grouping SLOs in dashboard views that you create by hand. Labels must adhere to Prometheus label name schema - "^[a-zA-Z*][a-zA-Z0-9*]*$"
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name should be a short description of your indicator. Consider names like "API Availability"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def objectives(self) -> pulumi.Output[Sequence['outputs.SLOObjective']]:
        """
        Over each rolling time window, the remaining error budget will be calculated, and separate alerts can be generated for each time window based on the SLO burn rate or remaining error budget.
        """
        return pulumi.get(self, "objectives")

    @_builtins.property
    @pulumi.getter
    def queries(self) -> pulumi.Output[Sequence['outputs.SLOQuery']]:
        """
        Query describes the indicator that will be measured against the objective. Freeform Query types are currently supported.
        """
        return pulumi.get(self, "queries")

    @_builtins.property
    @pulumi.getter(name="searchExpression")
    def search_expression(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of a search expression in Grafana Asserts. This is used in the SLO UI to open the Asserts RCA workbench and in alerts to link to the RCA workbench.
        """
        return pulumi.get(self, "search_expression")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[_builtins.str]:
        """
        UUID for the SLO. Custom UUIDs can be set. If not provided, a random UUID will be generated by the API.
        """
        return pulumi.get(self, "uuid")

