# I/O System

Modular I/O system supporting multiple file formats through a common VideoReader/VideoWriter interface.

## Factory Functions

```{eval-rst}
.. automodule:: pyflowreg.util.io.factory
   :members:
```

## Base Classes

```{eval-rst}
.. automodule:: pyflowreg.util.io._base
   :members:
   :show-inheritance:
```

## Dataset Discovery

```{eval-rst}
.. automodule:: pyflowreg.util.io._ds_io
   :members:
   :show-inheritance:
```

## File Format Support

### HDF5

```{eval-rst}
.. automodule:: pyflowreg.util.io.hdf5
   :members:
   :show-inheritance:
```

### TIFF

```{eval-rst}
.. automodule:: pyflowreg.util.io.tiff
   :members:
   :show-inheritance:
```

### MATLAB MAT

```{eval-rst}
.. automodule:: pyflowreg.util.io.mat
   :members:
   :show-inheritance:
```

### MDF (Sutter MesaScope)

```{eval-rst}
.. automodule:: pyflowreg.util.io.mdf
   :members:
   :show-inheritance:
```

## Multi-File Handling

```{eval-rst}
.. automodule:: pyflowreg.util.io.multifile_wrappers
   :members:
   :show-inheritance:
```

## Array I/O

```{eval-rst}
.. automodule:: pyflowreg.util.io._arr
   :members:
   :show-inheritance:
```

## Null Writer (Callback-Only Processing)

```{eval-rst}
.. automodule:: pyflowreg.util.io._null
   :members:
   :show-inheritance:
```

## ScanImage Support

```{eval-rst}
.. automodule:: pyflowreg.util.io._scanimage
   :members:
```
