"""Data models for Archer API."""

# Add Pydantic models here as needed

from .record import (
    FieldContent,
    FieldType,
    RecordContent,
    RecordResponse,
    RecordCreateRequest,
    RecordUpdateRequest
)
from .search import (
    SearchOperator,
    SearchFilter,
    SearchCriteria,
    SearchResponse
)
from .attachment import (
    AttachmentWrapper,
    AttachmentUploadRequest,
    AttachmentResponse
)
from .application import (
    Application,
    FieldDefinition,
    FieldTypeEnum
)
from .questionnaire import (
    Questionnaire,
    QuestionnaireRule
)

__all__ = [
    # Record models
    "FieldContent",
    "FieldType",
    "RecordContent",
    "RecordResponse",
    "RecordCreateRequest",
    "RecordUpdateRequest",
    # Search models
    "SearchOperator",
    "SearchFilter",
    "SearchCriteria",
    "SearchResponse",
    # Attachment models
    "AttachmentWrapper",
    "AttachmentUploadRequest",
    "AttachmentResponse",
    # Application models
    "Application",
    "Questionnaire",
    "QuestionnaireRule",
    "FieldDefinition",
    "FieldTypeEnum",
]