from py_ullr.client import ArcherClient, ArcherConfig


def test_client_requires_config_or_base_url():
    try:
        ArcherClient()
        raised = False
    except ValueError:
        raised = True
    assert raised


def test_client_with_config_sets_rest():
    config = ArcherConfig(base_url="https://x", instance_name="inst")
    client = ArcherClient(config=config)
    assert hasattr(client, "rest")
    assert client.config is config


def test_client_authenticate_calls_authenticator():
    config = ArcherConfig(base_url="https://x", instance_name="inst")
    client = ArcherClient(config=config)

    class FakeAuth:
        def authenticate(self, username, password, user_domain=""):
            return "token"

        def logout(self):
            pass

        @property
        def is_authenticated(self):
            return True

        @property
        def session_token(self):
            return "token"

    client._authenticator = FakeAuth()
    token = client.authenticate("u", "p")
    assert token == "token"
    assert client.is_authenticated is True
