import pytest

from py_ullr.rest.records import RecordsAPI


def test_infer_field_type_text():
    assert RecordsAPI._infer_field_type("hello") == 1


def test_infer_field_type_numeric():
    assert RecordsAPI._infer_field_type(42) == 2
    assert RecordsAPI._infer_field_type(3.14) == 2


def test_infer_field_type_bool():
    assert RecordsAPI._infer_field_type(True) == 3
    assert RecordsAPI._infer_field_type(False) == 3


def test_infer_field_type_list():
    assert RecordsAPI._infer_field_type([1, 2, 3]) == 4


def test_infer_field_type_default_object():
    class Foo:
        pass

    assert RecordsAPI._infer_field_type(Foo()) == 1
