# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['monday_item_parser', 'monday_item_parser.fields']

package_data = \
{'': ['*']}

install_requires = \
['bidict>=0.21.4,<0.22.0', 'monday>=1.2.7,<2.0.0', 'requests>=2.27.1,<3.0.0']

setup_kwargs = {
    'name': 'monday-item-parser',
    'version': '0.2.1',
    'description': 'monday-item-parser is a library used to define Monday items structure in a specific board, and lets the user fetch, create, update and delete items from this board.',
    'long_description': '# [Monday Item Parser](https://github.com/avivatedgi/monday-item-parser)\n\n[![Tests](https://github.com/avivatedgi/monday-item-parser/actions/workflows/tests.yml/badge.svg)](https://github.com/avivatedgi/monday-item-parser/actions/workflows/tests.yml) [![PyPI version](https://badge.fury.io/py/monday-item-parser.svg)](https://badge.fury.io/py/monday-item-parser)\n\n## Introduction\n\n[Monday Item Parser](https://github.com/avivatedgi/monday-item-parser) is a library used to define [Monday](www.monday.com) items structure in a specific board, and lets the user fetch, create, update and delete items from this board.\n\n## Installation\n\n```bash\npip install monday-item-parser\n```\n\n## Requirements\n\n* Python >= 3.7\n* [Monday library](https://github.com/ProdPerfect/monday) for the Mondayhttp client\n\n## Changelog\n\n* 0.2.1 (2021-01-16) - Added hooks for field values.\n* 0.2.0 (2021-01-14) - Updated the item\'s field value set method to be explicit (without calling `.value`)\n* 0.1.2 (2021-01-13) - Fixed a small bug in the `Item::__init__` function\n* 0.1.1 (2021-01-13) - Still first release, but got some problems with PyPI and Github Workflows\n* 0.1.0 (2021-01-13) - First release\n\n## How to use\n\n### Items\n\nItems are the full board item structure, built from fields.\n\n```python\nfrom monday import MondayClient\nfrom monday_item_parser import Item, CheckboxField\n\n\nboard_id = 1234\nmonday_client = MondayClient("MONDAY_API_KEY_HERE")\n\n\nclass MyItem(Item, board_id=board_id, monday_client=monday_client):\n    checkbox_example = CheckboxField()\n\n    # Can be declared either as a type or as an instance, so this is good as well:\n    checkbox_example = CheckboxField\n```\n\n**NOTE:** The variables in your item class must be named EXACTLY the same as in your monday board but in lower-case and replace spaces into underscore. For example a column in Monday with the name `My Nice Column` will must be defined in your item class `my_nice_column`.\n\n#### Fetch items from board\n\n```pycon\n>>> for item in ExampleItem.fetch_items_from_board():\n>>>     print(item)\n```\n\n![Items Preview](docs/images/items-print.png)\n\n#### Create Item\n\n**NOTE:** You can only create an item that isn\'t fetched from the board / already created using this exact function. If you want to create a new item that was fetched from the board you should use the `duplicate_item` function\n\n```pycon\n>>> item = MyItem(checkbox_example=True)\n>>> item.name = "My First Example"\n>>> item.create_item()\n```\n\n#### Duplicate Item\n\n**NOTE:** You can only duplicate an item that was fetched from the board / created by the `create_item` function.\n\n```pycon\n>>> new_item = item.duplicate_item()\n```\n\n#### Update Item\n\n**NOTE:** You can only update an item that was fetched from the board / created by the `create_item` function.\n\n```pycon\n>>> new_item.name = \'Updated Item\'\n>>> new_item.checkbox_example = False\n>>> new_item.update_item()\n```\n\n#### Delete Item\n\n**NOTE:** You can only delete an item that was fetched from the board / created by the `create_item` function.\n\n```pycon\n>>> new_item.delete_item()\n```\n\n#### Get Group Ids in Board\n\n```pycon\n>>> for group_id in ItemExample.fetch_group_ids():\n>>>     print(group_id)\n"topics"\n"group_title"\n```\n\n#### Hook Field Values\n\nA hook can be registered for whenever the value on a specific field is changed.\n\n```python\nfrom monday_item_parser import *\n\nclass ItemWithFieldHook(Item, monday_client=client, board_id=testing_board_id):\n    status_example = StatusField\n    checkbox_example = CheckboxField\n\n    @field_updated_hook(status_example)\n    def status_example_hook(self):\n        if self.status_example.value is not None:\n            # In the hook you must update the value with the\n            # `.value` attribute if you don\'t want to trigger the hook again\n            self.status_example.value += 1\n        else:\n            self.status_example.value = 0\n\nitem = ItemWithFieldHook()\n# Trigger the hook by setting the value WITHOUT the `.value` attribute\nitem.status_example = 5\nassert item.status_example.value == 6\n```\n\n### Fields\n\nField is actually an Monday board\'s item column. The currently supported types are:\n\n| Monday Column Type | Library Class Name |\n| ------------------ | ------------------ |\n| Checkbox | `CheckboxField` |\n| Country | `CountryField` |\n| Date | `DateField` |\n| Email | `EmailField` |\n| Link | `LinkField` |\n| Number | `NumberField` |\n| People | `PeopleField` |\n| Phone | `PhoneField` |\n| Status | `StatusField` |\n| Tags | `TagsField` |\n| Text | `TextField` |\n| Timeline | `TimelineField` |\n\n#### Full Example\n\n```python\nclass ItemExample(Item, monday_client=client, board_id=testing_board_id):\n    status_example = StatusField\n    date_example = DateField\n    checkbox_example = CheckboxField\n    country_example = CountryField\n    email_example = EmailField\n    link_example = LinkField\n    numbers_example = NumberField\n    people_example = PeopleField\n    phone_example = PhoneField\n    tags_example = TagsField\n    text_example = TextField\n    timeline_example = TimelineField\n\nitem = ItemExample()\n\n# Setting the values of an item\nitem.item_name = "Aviv Atedgi"\nitem.status_example = "Working on it"\nitem.date_example = datetime.now()\nitem.checkbox_example = True\nitem.country_example = "IL"\nitem.email_example = "aviv.atedgi2000@gmail.com"\nitem.link_example.url = "https://www.github.com/avivatedgi"\nitem.link_example.text = "My Github Profile"\nitem.numbers_example = 192.4\nitem.people_example = [Person(25200525)]\nitem.phone_example.country_code = "IL"\nitem.phone_example.phone = "0501234567"\nitem.tags_example = [12808387]\nitem.text_example = "My Cool Text Example"\nitem.timeline_example.start = datetime.strptime("2000-05-01", "%Y-%m-%d")\nitem.timeline_example.end = datetime.now()\n\n# Getting the values of an item\nprint("Status Example =", item.status_example.value)\nprint("Date Example =", item.date_example.value)\nprint("Checkbox Example =", item.checkbox_example.value)\nprint("Country Example =", item.country_example.value)\nprint("Email Example =", item.email_example.value)\nprint("Link Example URL =", item.link_example.value.url)\nprint("Link Example Text =", item.link_example.value.text)\nprint("Numbers Example =", item.numbers_example.value)\nprint("People Example =", item.people_example.value)\nprint("Phone Example Country Code =", item.phone_example.value.country_code)\nprint("Phone Example Phone Number =", item.phone_example.value.phone)\nprint("Tags Example =", item.tags_example.value)\nprint("Text Example =", item.text_example.value)\nprint("Timeline Example Start Date =", item.timeline_example.value.start)\nprint("Timeline Example End Date =", item.timeline_example.value.end)\n```\n\n## Special Thanks\n\n* [Hydration](https://github.com/shustinm/hydration) ([Michael Shustin](https://github.com/shustinm/)) For the idea of the items metaclass\n* [Monday](https://github.com/ProdPerfect/monday) ([ProdPerfect](https://github.com/ProdPerfect)) For the Monday client use in the library\n',
    'author': 'Aviv Atedgi',
    'author_email': 'aviv.atedgi2000@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
