# coding: utf-8

"""
    Aignostics Platform API

     The Aignostics Platform is a cloud-based service that enables organizations to access advanced computational pathology applications through a secure API.  The platform provides standardized access to Aignostics' portfolio of computational pathology solutions, with Atlas H&E-TME serving as an example of the available API endpoints.   To begin using the platform, your organization must first be registered by our business support team. If you don't have an account yet, please contact your account manager or email support@aignostics.com to get started.   More information about our applications can be found on [https://platform.aignostics.com](https://platform.aignostics.com).  **How to authorize and test API endpoints:**  1. Click the \"Authorize\" button in the right corner below 3. Click \"Authorize\" button in the dialog to log in with your Aignostics Platform credentials 4. After successful login, you'll be redirected back and can use \"Try it out\" on any endpoint  **Note**: You only need to authorize once per session. The lock icons next to endpoints will show green when authorized.  

    The version of the OpenAPI document: 1.0.0.beta7
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aignx.codegen.models.application_version import ApplicationVersion
from typing import Optional, Set
from typing_extensions import Self

class ApplicationReadShortResponse(BaseModel):
    """
    Response schema for `List available applications` and `Read Application by Id` endpoints
    """ # noqa: E501
    application_id: StrictStr = Field(description="Application ID")
    name: StrictStr = Field(description="Application display name")
    regulatory_classes: List[StrictStr] = Field(description="Regulatory classes, to which the applications comply with. Possible values include: RUO, IVDR, FDA.")
    description: StrictStr = Field(description="Describing what the application can do ")
    latest_version: Optional[ApplicationVersion] = None
    __properties: ClassVar[List[str]] = ["application_id", "name", "regulatory_classes", "description", "latest_version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApplicationReadShortResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of latest_version
        if self.latest_version:
            _dict['latest_version'] = self.latest_version.to_dict()
        # set to None if latest_version (nullable) is None
        # and model_fields_set contains the field
        if self.latest_version is None and "latest_version" in self.model_fields_set:
            _dict['latest_version'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApplicationReadShortResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "application_id": obj.get("application_id"),
            "name": obj.get("name"),
            "regulatory_classes": obj.get("regulatory_classes"),
            "description": obj.get("description"),
            "latest_version": ApplicationVersion.from_dict(obj["latest_version"]) if obj.get("latest_version") is not None else None
        })
        return _obj


