# coding: utf-8

"""
    Aignostics Platform API

     The Aignostics Platform is a cloud-based service that enables organizations to access advanced computational pathology applications through a secure API.  The platform provides standardized access to Aignostics' portfolio of computational pathology solutions, with Atlas H&E-TME serving as an example of the available API endpoints.   To begin using the platform, your organization must first be registered by our business support team. If you don't have an account yet, please contact your account manager or email support@aignostics.com to get started.   More information about our applications can be found on [https://platform.aignostics.com](https://platform.aignostics.com).  **How to authorize and test API endpoints:**  1. Click the \"Authorize\" button in the right corner below 3. Click \"Authorize\" button in the dialog to log in with your Aignostics Platform credentials 4. After successful login, you'll be redirected back and can use \"Try it out\" on any endpoint  **Note**: You only need to authorize once per session. The lock icons next to endpoints will show green when authorized.  

    The version of the OpenAPI document: 1.0.0.beta7
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Auth0Organization(BaseModel):
    """
    Model for Auth0 Organization object returned from Auth0 API.  For details, see: https://auth0.com/docs/api/management/v2#!/Organizations/get_organizations_by_id  Aignostics-specific metadata fields are extracted from the `metadata` field.
    """ # noqa: E501
    id: StrictStr = Field(description="Unique organization identifier")
    name: Optional[StrictStr] = None
    display_name: Optional[StrictStr] = None
    aignostics_bucket_hmac_access_key_id: StrictStr = Field(description="HMAC access key ID for the Aignostics-provided storage bucket. Used to authenticate requests for uploading files and generating signed URLs")
    aignostics_bucket_hmac_secret_access_key: StrictStr = Field(description="HMAC secret access key paired with the access key ID. Keep this credential secure.")
    aignostics_bucket_name: StrictStr = Field(description="Name of the bucket provided by Aignostics for storing input artifacts (slide images)")
    aignostics_bucket_protocol: StrictStr = Field(description="Protocol to use for bucket access. Defines the URL scheme for connecting to the storage service")
    aignostics_logfire_token: StrictStr = Field(description="Authentication token for Logfire observability service. Enables sending application logs and performance metrics to Aignostics for monitoring and support")
    aignostics_sentry_dsn: StrictStr = Field(description="Data Source Name (DSN) for Sentry error tracking service. Allows automatic reporting of errors and exceptions to Aignostics support team")
    __properties: ClassVar[List[str]] = ["id", "name", "display_name", "aignostics_bucket_hmac_access_key_id", "aignostics_bucket_hmac_secret_access_key", "aignostics_bucket_name", "aignostics_bucket_protocol", "aignostics_logfire_token", "aignostics_sentry_dsn"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Auth0Organization from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['display_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Auth0Organization from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "display_name": obj.get("display_name"),
            "aignostics_bucket_hmac_access_key_id": obj.get("aignostics_bucket_hmac_access_key_id"),
            "aignostics_bucket_hmac_secret_access_key": obj.get("aignostics_bucket_hmac_secret_access_key"),
            "aignostics_bucket_name": obj.get("aignostics_bucket_name"),
            "aignostics_bucket_protocol": obj.get("aignostics_bucket_protocol"),
            "aignostics_logfire_token": obj.get("aignostics_logfire_token"),
            "aignostics_sentry_dsn": obj.get("aignostics_sentry_dsn")
        })
        return _obj
