# coding: utf-8

"""
    Aignostics Platform API

     The Aignostics Platform is a cloud-based service that enables organizations to access advanced computational pathology applications through a secure API.  The platform provides standardized access to Aignostics' portfolio of computational pathology solutions, with Atlas H&E-TME serving as an example of the available API endpoints.   To begin using the platform, your organization must first be registered by our business support team. If you don't have an account yet, please contact your account manager or email support@aignostics.com to get started.   More information about our applications can be found on [https://platform.aignostics.com](https://platform.aignostics.com).  **How to authorize and test API endpoints:**  1. Click the \"Authorize\" button in the right corner below 3. Click \"Authorize\" button in the dialog to log in with your Aignostics Platform credentials 4. After successful login, you'll be redirected back and can use \"Try it out\" on any endpoint  **Note**: You only need to authorize once per session. The lock icons next to endpoints will show green when authorized.  

    The version of the OpenAPI document: 1.0.0.beta7
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aignx.codegen.models.item_output import ItemOutput
from aignx.codegen.models.item_state import ItemState
from aignx.codegen.models.item_termination_reason import ItemTerminationReason
from aignx.codegen.models.output_artifact_result_read_response import OutputArtifactResultReadResponse
from typing import Optional, Set
from typing_extensions import Self

class ItemResultReadResponse(BaseModel):
    """
    Response schema for items in `List Run Items` endpoint
    """ # noqa: E501
    item_id: StrictStr = Field(description="Item UUID generated by the Platform")
    external_id: StrictStr = Field(description="The external_id of the item from the user payload")
    custom_metadata: Optional[Dict[str, Any]]
    custom_metadata_checksum: Optional[StrictStr] = None
    state: ItemState = Field(description=" The item moves from `PENDING` to `PROCESSING` to `TERMINATED` state. When terminated, consult the `termination_reason` property to see whether it was successful.     ")
    output: ItemOutput = Field(description="The output status of the item (NONE, FULL)")
    termination_reason: Optional[ItemTerminationReason] = None
    error_message: Optional[StrictStr] = None
    terminated_at: Optional[datetime] = None
    output_artifacts: List[OutputArtifactResultReadResponse] = Field(description=" The list of the results generated by the application algorithm. The number of files and their types depend on the particular application version, call `/v1/versions/{version_id}` to get the details.     ")
    error_code: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["item_id", "external_id", "custom_metadata", "custom_metadata_checksum", "state", "output", "termination_reason", "error_message", "terminated_at", "output_artifacts", "error_code"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ItemResultReadResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in output_artifacts (list)
        _items = []
        if self.output_artifacts:
            for _item_output_artifacts in self.output_artifacts:
                if _item_output_artifacts:
                    _items.append(_item_output_artifacts.to_dict())
            _dict['output_artifacts'] = _items
        # set to None if custom_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.custom_metadata is None and "custom_metadata" in self.model_fields_set:
            _dict['custom_metadata'] = None

        # set to None if custom_metadata_checksum (nullable) is None
        # and model_fields_set contains the field
        if self.custom_metadata_checksum is None and "custom_metadata_checksum" in self.model_fields_set:
            _dict['custom_metadata_checksum'] = None

        # set to None if termination_reason (nullable) is None
        # and model_fields_set contains the field
        if self.termination_reason is None and "termination_reason" in self.model_fields_set:
            _dict['termination_reason'] = None

        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['error_message'] = None

        # set to None if terminated_at (nullable) is None
        # and model_fields_set contains the field
        if self.terminated_at is None and "terminated_at" in self.model_fields_set:
            _dict['terminated_at'] = None

        # set to None if error_code (nullable) is None
        # and model_fields_set contains the field
        if self.error_code is None and "error_code" in self.model_fields_set:
            _dict['error_code'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ItemResultReadResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "item_id": obj.get("item_id"),
            "external_id": obj.get("external_id"),
            "custom_metadata": obj.get("custom_metadata"),
            "custom_metadata_checksum": obj.get("custom_metadata_checksum"),
            "state": obj.get("state"),
            "output": obj.get("output"),
            "termination_reason": obj.get("termination_reason"),
            "error_message": obj.get("error_message"),
            "terminated_at": obj.get("terminated_at"),
            "output_artifacts": [OutputArtifactResultReadResponse.from_dict(_item) for _item in obj["output_artifacts"]] if obj.get("output_artifacts") is not None else None,
            "error_code": obj.get("error_code")
        })
        return _obj


