# coding: utf-8

"""
    Aignostics Platform API

     The Aignostics Platform is a cloud-based service that enables organizations to access advanced computational pathology applications through a secure API.  The platform provides standardized access to Aignostics' portfolio of computational pathology solutions, with Atlas H&E-TME serving as an example of the available API endpoints.   To begin using the platform, your organization must first be registered by our business support team. If you don't have an account yet, please contact your account manager or email support@aignostics.com to get started.   More information about our applications can be found on [https://platform.aignostics.com](https://platform.aignostics.com).  **How to authorize and test API endpoints:**  1. Click the \"Authorize\" button in the right corner below 3. Click \"Authorize\" button in the dialog to log in with your Aignostics Platform credentials 4. After successful login, you'll be redirected back and can use \"Try it out\" on any endpoint  **Note**: You only need to authorize once per session. The lock icons next to endpoints will show green when authorized.  

    The version of the OpenAPI document: 1.0.0.beta7
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from aignx.codegen.models.artifact_output import ArtifactOutput
from aignx.codegen.models.artifact_state import ArtifactState
from aignx.codegen.models.artifact_termination_reason import ArtifactTerminationReason
from typing import Optional, Set
from typing_extensions import Self

class OutputArtifactResultReadResponse(BaseModel):
    """
    OutputArtifactResultReadResponse
    """ # noqa: E501
    output_artifact_id: StrictStr = Field(description="The Id of the artifact. Used internally")
    name: StrictStr = Field(description=" Name of the output from the output schema from the `/v1/versions/{version_id}` endpoint.     ")
    metadata: Optional[Dict[str, Any]] = None
    state: ArtifactState = Field(description="The current state of the artifact (PENDING, PROCESSING, TERMINATED)")
    termination_reason: Optional[ArtifactTerminationReason] = None
    output: ArtifactOutput = Field(description="The output status of the artifact (NONE, FULL)")
    error_message: Optional[StrictStr] = None
    download_url: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=2083)]]
    error_code: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["output_artifact_id", "name", "metadata", "state", "termination_reason", "output", "error_message", "download_url", "error_code"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OutputArtifactResultReadResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if termination_reason (nullable) is None
        # and model_fields_set contains the field
        if self.termination_reason is None and "termination_reason" in self.model_fields_set:
            _dict['termination_reason'] = None

        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['error_message'] = None

        # set to None if download_url (nullable) is None
        # and model_fields_set contains the field
        if self.download_url is None and "download_url" in self.model_fields_set:
            _dict['download_url'] = None

        # set to None if error_code (nullable) is None
        # and model_fields_set contains the field
        if self.error_code is None and "error_code" in self.model_fields_set:
            _dict['error_code'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OutputArtifactResultReadResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "output_artifact_id": obj.get("output_artifact_id"),
            "name": obj.get("name"),
            "metadata": obj.get("metadata"),
            "state": obj.get("state"),
            "termination_reason": obj.get("termination_reason"),
            "output": obj.get("output"),
            "error_message": obj.get("error_message"),
            "download_url": obj.get("download_url"),
            "error_code": obj.get("error_code")
        })
        return _obj


