# coding: utf-8

"""
    Aignostics Platform API

     The Aignostics Platform is a cloud-based service that enables organizations to access advanced computational pathology applications through a secure API.  The platform provides standardized access to Aignostics' portfolio of computational pathology solutions, with Atlas H&E-TME serving as an example of the available API endpoints.   To begin using the platform, your organization must first be registered by our business support team. If you don't have an account yet, please contact your account manager or email support@aignostics.com to get started.   More information about our applications can be found on [https://platform.aignostics.com](https://platform.aignostics.com).  **How to authorize and test API endpoints:**  1. Click the \"Authorize\" button in the right corner below 3. Click \"Authorize\" button in the dialog to log in with your Aignostics Platform credentials 4. After successful login, you'll be redirected back and can use \"Try it out\" on any endpoint  **Note**: You only need to authorize once per session. The lock icons next to endpoints will show green when authorized.  

    The version of the OpenAPI document: 1.0.0.beta7
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aignx.codegen.models.run_item_statistics import RunItemStatistics
from aignx.codegen.models.run_output import RunOutput
from aignx.codegen.models.run_state import RunState
from aignx.codegen.models.run_termination_reason import RunTerminationReason
from typing import Optional, Set
from typing_extensions import Self

class RunReadResponse(BaseModel):
    """
    Response schema for `Get run details` endpoint
    """ # noqa: E501
    run_id: StrictStr = Field(description="UUID of the application")
    application_id: StrictStr = Field(description="Application id")
    version_number: StrictStr = Field(description="Application version number")
    state: RunState = Field(description="When the run request is received by the Platform, the `state` of it is set to `PENDING`. The state changes to `PROCESSING` when at least one item is being processed. After `PROCESSING`, the state of the run can switch back to `PENDING` if there are no processing items, or to `TERMINATED` when the run finished processing.")
    output: RunOutput = Field(description="The status of the output of the run. When 0 items are successfully processed the output is `NONE`, after one item is successfully processed, the value is set to `PARTIAL`. When all items of the run are successfully processed, the output is set to `FULL`.")
    termination_reason: Optional[RunTerminationReason]
    error_code: Optional[StrictStr]
    error_message: Optional[StrictStr]
    statistics: RunItemStatistics = Field(description="Aggregated statistics of the run execution")
    custom_metadata: Optional[Dict[str, Any]] = None
    custom_metadata_checksum: Optional[StrictStr] = None
    submitted_at: datetime = Field(description="Timestamp showing when the run was triggered")
    submitted_by: StrictStr = Field(description="Id of the user who triggered the run")
    terminated_at: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["run_id", "application_id", "version_number", "state", "output", "termination_reason", "error_code", "error_message", "statistics", "custom_metadata", "custom_metadata_checksum", "submitted_at", "submitted_by", "terminated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RunReadResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        # set to None if termination_reason (nullable) is None
        # and model_fields_set contains the field
        if self.termination_reason is None and "termination_reason" in self.model_fields_set:
            _dict['termination_reason'] = None

        # set to None if error_code (nullable) is None
        # and model_fields_set contains the field
        if self.error_code is None and "error_code" in self.model_fields_set:
            _dict['error_code'] = None

        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['error_message'] = None

        # set to None if custom_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.custom_metadata is None and "custom_metadata" in self.model_fields_set:
            _dict['custom_metadata'] = None

        # set to None if custom_metadata_checksum (nullable) is None
        # and model_fields_set contains the field
        if self.custom_metadata_checksum is None and "custom_metadata_checksum" in self.model_fields_set:
            _dict['custom_metadata_checksum'] = None

        # set to None if terminated_at (nullable) is None
        # and model_fields_set contains the field
        if self.terminated_at is None and "terminated_at" in self.model_fields_set:
            _dict['terminated_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RunReadResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "run_id": obj.get("run_id"),
            "application_id": obj.get("application_id"),
            "version_number": obj.get("version_number"),
            "state": obj.get("state"),
            "output": obj.get("output"),
            "termination_reason": obj.get("termination_reason"),
            "error_code": obj.get("error_code"),
            "error_message": obj.get("error_message"),
            "statistics": RunItemStatistics.from_dict(obj["statistics"]) if obj.get("statistics") is not None else None,
            "custom_metadata": obj.get("custom_metadata"),
            "custom_metadata_checksum": obj.get("custom_metadata_checksum"),
            "submitted_at": obj.get("submitted_at"),
            "submitted_by": obj.get("submitted_by"),
            "terminated_at": obj.get("terminated_at")
        })
        return _obj


