# This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
# If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.
# © 2025 cswimr

"""Tidegear version information."""

# This file is automatically generated on build, do not edit!
# Do not commit this file to source control!

from furl import furl

from tidegear.metadata import Repository, SemVer, TidegearMeta

meta: TidegearMeta = TidegearMeta(
    version=SemVer._from_tuple((1, 3, 10)),  # noqa: SLF001
    repository=Repository(
        owner="cswimr",
        name="tidegear",
        url=furl("https://c.csw.im/cswimr/tidegear"),
    ),
)
"""Tidegear Metadata object. This is automatically generated on build, so the version information will change depending on your Tidegear version."""

version: SemVer = meta.version
"""A SemVer object storing Tidegear's version."""
__version__: str = str(meta.version)
"""A string storing Tidegear's version."""
