## Source for pip package splusdata

![](https://splus.cloud/images/splus_logo_fundo_branco.jpg)

This is a tool mainly to query and download S-PLUS data.

<p>S-PLUS is a survey done with the dedicate T80-South telescope, a robotic 80cm telescope located at Cerro Tololo Interamerican Observatory, in Chile, equipped with a wide-field optical camera. S-PLUS will cover 9300 square degrees of the southern sky. The data generated by S-PLUS consist of images and catalogues prepared by the team at IAG-USP. The data available, iDR3, cover an area of 2000 square degrees and it is now available only for the internal S-PLUS community only. The paper of Mendes de Oliveira et al. (2019, https://arxiv.org/pdf/1907.01567.pdf) describes several aspects of the S-PLUS data, for DR1, which covered the Stripe82 area, but it is extensive to the present data release also. Section 4 of that paper describes  the data reduction pipeline, the production of multi-band data and corresponding photometric catalogues, data calibration strategies, it shows tests of the PSF stability over the images and it explains how the photometry and photometric redshifts were obtained, describing also their depths.</p>

install by running:

    pip install splusdata
    
or:

    pip3 install splusdata

<br>
Check some more detailed docs in the link below:

[DOCS](https://splus.cloud/documentation)

<br>
There is a quick demo showing the functionalities of the package at this notebook below

[notebook](https://github.com/Schwarzam/splusdata/blob/master/Demo.ipynb)


If you're interested in contributing to open-source projects and want to make a positive impact in the astronomical community, we encourage you to consider getting involved with the splusdata project!

As an open-source project, splusdata welcomes contributions from anyone interested in improving the code and functionality of the project. Whether you're a seasoned developer or just starting out, there are many ways you can help make a difference.

There are many ways to contribute to splusdata, including writing code, improving documentation, testing the software, reporting bugs, and more. You don't have to be an expert in Python or astronomy to contribute - there are many opportunities for all skill levels.

In addition to encouraging contributions to splusdata, we also welcome any suggestions or ideas for new features and functionalities that could improve the library. We recognize that the astronomical community is constantly evolving, and new needs and requirements may arise as a result.

If you have any ideas for new features or functionalities that you think would be useful for splusdata, we encourage you to share them with us. We welcome input and suggestions from the community, and we value your feedback and ideas.

Whether it's a new data visualization tool, an improved database search algorithm, or a new set of analysis functions, we are always looking for ways to improve the capabilities of splusdata. We believe that by working together and sharing our knowledge and expertise, we can create a better and more accessible tool for the astronomical community.

So, if you have an idea or suggestion for a new feature or functionality, we encourage you to share it with us. We welcome any and all contributions and suggestions, and we look forward to working with you to make splusdata the best it can be.

Any doubts, sugestions or problems about this tool please write to gustavo.b.schwarz@gmail.com

Cite:

```
@software{oliveira_schwarz_2022_10980447,
  author       = {Oliveira Schwarz, G. B.},
  title        = {Southern Photometric Local Universe Survey Cloud},
  month        = jan,
  year         = 2022,
  publisher    = {Zenodo},
  doi          = {10.5281/zenodo.10980447},
  url          = {https://doi.org/10.5281/zenodo.10980447},
}
```

