BANDS = ['u', 'J0378', 'J0395', 'J0410', 'J0430', 'g', 'J0515', 'r', 'J0660', 'i', 'J0861', 'z']
WAVELENGHTS = [3536, 3770, 3940, 4094, 4292, 4751, 5133, 6258, 6614, 7690, 8611, 8831]

DR_POINTINGS = {
    "dr4": 
        {
            "link": "https://splus.cloud/files/documentation/iDR4/tabelas/iDR4_pointings.csv",
            "ra_col": "RA", 
            "dec_col": "DEC",
            "field_col": "Field"
        },
    "dr5": 
        {
            "link": "https://splus.cloud/files/documentation/idr5/auxiliary_tables/iDR5_pointings.csv",
            "ra_col": "RA_d",
            "dec_col": "DEC_d",
            "field_col": "iDR5_Field_Name"
        },
    "dr6": 
        {
            "link": "https://splus.cloud/files/dr6_docs/dr6_list.csv",
            "ra_col": "ra",
            "dec_col": "dec",
            "field_col": "field"
        }
}

BANDWAVEINFO_COLS = ['central_wave','delta_wave','trapz_wave','trapz_width','mean_wave','mean_width','mean_1_wave','mean_1_width','pivot_wave','alambda_av']

BANDWAVEINFO = {
    'u': [3576.5900319003185,324.89284892848946,3542.1443522227532,322.8263652334996,3542.1443530585752,322.8263652334996,3541.969648229418,322.47994720424987,3533.2815060278176,1.6104999642584739],
    'J0378': [3770.667656676567,150.9900099000988,3774.011802885624,135.9577193603005,3774.0118028527427,135.9577193603005,3773.981717868756,135.7529151577093,3773.1649561852896,1.5176985654998583],
    'J0395': [3940.669006690067,102.79782797828011,3941.090848532596,100.77648141472922,3941.0908486234594,100.77648141472922,3941.074611723043,100.664883796743,3940.6981217186826,1.4589092149273093],
    'J0410': [4094.0795907959077,200.31290312903093,4096.244672289782,193.3458020035327,4096.244672355809,193.3458020035327,4096.2061617095505,193.11785361385836,4094.928007328532,1.4033758391668887],
    'J0430': [4292.020120201202,200.16240162401664,4293.375187582308,195.06906616375664,4293.375187489372,195.06906616375664,4293.3383586839045,194.82176337031825,4292.105790056625,1.333792079417452],
    'g': [4774.026040260403,1505.4610546105455,4821.096812428365,1312.4365137224963,4821.096812419468,1312.4365137224963,4821.067328442389,1312.1660034147683,4758.487858695381,1.1988078567002278],
    'J0515': [5132.820973209732,207.0569705697053,5134.215757880079,203.61492665730344,5134.215757789297,203.61492665730344,5134.203017754601,203.4775265629296,5133.132479753686,1.0983855043535193],
    'r': [6274.743347433474,1436.69456694567,6295.687061301507,1274.085080552066,6295.687061340775,1274.085080552066,6295.670469955384,1273.717585280557,6251.8309742925085,0.8639150819807985],
    'J0660': [6613.9931899319,147.28497284972855,6614.316749499244,146.66560010379152,6614.316749615694,146.66560010379152,6614.295914036835,146.52087279655584,6613.875560388883,0.7979103155197371],
    'i': [7702.49932499325,1506.845468454685,7709.955146600505,1438.1013394782774,7709.955151443986,1438.1013394782774,7709.81234140586,1437.2077440992825,7670.614459826697,0.6479238989570093],
    'J0861': [8611.481664816649,409.6853968539672,8609.86480549928,401.9084864881284,8609.866138424737,401.90954637204015,8609.836152859618,401.52828207867316,8607.254217015387,0.5391299762216387],
    'z': [8881.70071700717,1270.4971049710512,8985.814083997144,1308.4931400034807,8985.814681949101,1308.4931400034807,8986.541255819202,1307.6954289945693,8941.476066226343,0.5121720871113746]
}

def get_band_info(band):
    '''
    Retreive T80-South filter information.

    Parameters
    ----------
    band : str
        The name of the T80-S filter. 

    Returns
    -------
    None or dict
        If the information for the required band is found, 
        returns a dictionary, otherwise None.

    See Also
    --------
    https://github.com/splus-collab/splus_filters for more info about T80-South filters.
    '''
    retval = None
    band = band.lower()
    # solve for U or u, G or g, etc...
    key = [x for x in BANDWAVEINFO.keys() if band.lower() in x.lower()]
    if len(key) == 1:
        key = key[0]
        retval = {k: v for (k, v) in zip(BANDWAVEINFO_COLS, BANDWAVEINFO[key])}
    return retval