from typing import List, Optional

from zai.core import BaseModel


class VideoResult(BaseModel):
	"""
	Video generation result

	Attributes:
		url (str): Video url
		cover_image_url (str): Preview image
	"""

	url: str
	cover_image_url: str


class VideoObject(BaseModel):
	"""
	Video generation object

	Attributes:
		id (Optional[str]): The task order number generated by the Z.ai open platform.
							Please use this order number when calling the request result interface.
		model (str): Model name
		video_result (List[VideoResult]): Video generation result
		task_status (str): Processing status, PROCESSING (processing), SUCCESS (successful), FAIL (failed).
							Note: The processing status needs to be obtained by query.
		request_id (str): The task number submitted by the user when requesting on the client
							or the task number generated by the platform.
	"""

	id: Optional[str] = None
	model: str
	video_result: List[VideoResult]
	task_status: str
	request_id: str
