import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataTlsCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/d/certificate.html#url DataTlsCertificate#url}.
     *
     * @stability stable
     */
    readonly url: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/d/certificate.html#verify_chain DataTlsCertificate#verify_chain}.
     *
     * @stability stable
     */
    readonly verifyChain?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataTlsCertificateCertificates extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get isCa(): any;
    /**
     * @stability stable
     */
    get issuer(): string;
    /**
     * @stability stable
     */
    get notAfter(): string;
    /**
     * @stability stable
     */
    get notBefore(): string;
    /**
     * @stability stable
     */
    get publicKeyAlgorithm(): string;
    /**
     * @stability stable
     */
    get serialNumber(): string;
    /**
     * @stability stable
     */
    get sha1Fingerprint(): string;
    /**
     * @stability stable
     */
    get signatureAlgorithm(): string;
    /**
     * @stability stable
     */
    get subject(): string;
    /**
     * @stability stable
     */
    get version(): number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/tls/d/certificate.html tls_certificate}.
 *
 * @stability stable
 */
export declare class DataTlsCertificate extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/tls/d/certificate.html tls_certificate} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataTlsCertificateConfig);
    /**
     * @stability stable
     */
    certificates(index: string): DataTlsCertificateCertificates;
    /**
     * @stability stable
     */
    get id(): string;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    private _verifyChain?;
    /**
     * @stability stable
     */
    get verifyChain(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set verifyChain(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetVerifyChain(): void;
    /**
     * @stability stable
     */
    get verifyChainInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
