from aiohttp import web
from homeassistant.components import http as http
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.const import STATE_OFF as STATE_OFF, STATE_ON as STATE_ON
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.helpers.config_validation import PLATFORM_SCHEMA as PLATFORM_SCHEMA, PLATFORM_SCHEMA_BASE as PLATFORM_SCHEMA_BASE, time_period_str as time_period_str
from homeassistant.helpers.entity import Entity as Entity
from homeassistant.helpers.entity_component import EntityComponent as EntityComponent
from homeassistant.helpers.template import DATE_STR_FORMAT as DATE_STR_FORMAT
from homeassistant.util import dt as dt
from typing import Any

_LOGGER: Any
DOMAIN: str
ENTITY_ID_FORMAT: Any
SCAN_INTERVAL: Any

async def async_setup(hass, config): ...
async def async_setup_entry(hass: HomeAssistant, entry: ConfigEntry) -> bool: ...
async def async_unload_entry(hass: HomeAssistant, entry: ConfigEntry) -> bool: ...
def get_date(date): ...
def normalize_event(event): ...
def calculate_offset(event, offset): ...
def is_offset_reached(event): ...

class CalendarEventDevice(Entity):
    @property
    def event(self) -> None: ...
    @property
    def state_attributes(self): ...
    @property
    def state(self): ...
    async def async_get_events(self, hass, start_date, end_date) -> None: ...

class CalendarEventView(http.HomeAssistantView):
    url: str
    name: str
    component: Any
    def __init__(self, component: EntityComponent) -> None: ...
    async def get(self, request, entity_id): ...

class CalendarListView(http.HomeAssistantView):
    url: str
    name: str
    component: Any
    def __init__(self, component: EntityComponent) -> None: ...
    async def get(self, request: web.Request) -> web.Response: ...
