from homeassistant.backports.enum import StrEnum as StrEnum
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.const import SERVICE_CLOSE_COVER as SERVICE_CLOSE_COVER, SERVICE_CLOSE_COVER_TILT as SERVICE_CLOSE_COVER_TILT, SERVICE_OPEN_COVER as SERVICE_OPEN_COVER, SERVICE_OPEN_COVER_TILT as SERVICE_OPEN_COVER_TILT, SERVICE_SET_COVER_POSITION as SERVICE_SET_COVER_POSITION, SERVICE_SET_COVER_TILT_POSITION as SERVICE_SET_COVER_TILT_POSITION, SERVICE_STOP_COVER as SERVICE_STOP_COVER, SERVICE_STOP_COVER_TILT as SERVICE_STOP_COVER_TILT, SERVICE_TOGGLE as SERVICE_TOGGLE, SERVICE_TOGGLE_COVER_TILT as SERVICE_TOGGLE_COVER_TILT, STATE_CLOSED as STATE_CLOSED, STATE_CLOSING as STATE_CLOSING, STATE_OPEN as STATE_OPEN, STATE_OPENING as STATE_OPENING
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.helpers.config_validation import PLATFORM_SCHEMA as PLATFORM_SCHEMA, PLATFORM_SCHEMA_BASE as PLATFORM_SCHEMA_BASE
from homeassistant.helpers.entity import Entity as Entity, EntityDescription as EntityDescription
from homeassistant.helpers.entity_component import EntityComponent as EntityComponent
from homeassistant.loader import bind_hass as bind_hass
from typing import Any

_LOGGER: Any
DOMAIN: str
SCAN_INTERVAL: Any
ENTITY_ID_FORMAT: Any

class CoverDeviceClass(StrEnum):
    AWNING: str
    BLIND: str
    CURTAIN: str
    DAMPER: str
    DOOR: str
    GARAGE: str
    GATE: str
    SHADE: str
    SHUTTER: str
    WINDOW: str

DEVICE_CLASSES_SCHEMA: Any
DEVICE_CLASSES: Any
DEVICE_CLASS_AWNING: Any
DEVICE_CLASS_BLIND: Any
DEVICE_CLASS_CURTAIN: Any
DEVICE_CLASS_DAMPER: Any
DEVICE_CLASS_DOOR: Any
DEVICE_CLASS_GARAGE: Any
DEVICE_CLASS_GATE: Any
DEVICE_CLASS_SHADE: Any
DEVICE_CLASS_SHUTTER: Any
DEVICE_CLASS_WINDOW: Any
SUPPORT_OPEN: int
SUPPORT_CLOSE: int
SUPPORT_SET_POSITION: int
SUPPORT_STOP: int
SUPPORT_OPEN_TILT: int
SUPPORT_CLOSE_TILT: int
SUPPORT_STOP_TILT: int
SUPPORT_SET_TILT_POSITION: int
ATTR_CURRENT_POSITION: str
ATTR_CURRENT_TILT_POSITION: str
ATTR_POSITION: str
ATTR_TILT_POSITION: str

def is_closed(hass, entity_id): ...
async def async_setup(hass, config): ...
async def async_setup_entry(hass: HomeAssistant, entry: ConfigEntry) -> bool: ...
async def async_unload_entry(hass: HomeAssistant, entry: ConfigEntry) -> bool: ...

class CoverEntityDescription(EntityDescription):
    device_class: Union[CoverDeviceClass, str, None]

class CoverEntity(Entity):
    entity_description: CoverEntityDescription
    _attr_current_cover_position: Union[int, None]
    _attr_current_cover_tilt_position: Union[int, None]
    _attr_device_class: Union[CoverDeviceClass, str, None]
    _attr_is_closed: Union[bool, None]
    _attr_is_closing: Union[bool, None]
    _attr_is_opening: Union[bool, None]
    _attr_state: None
    _cover_is_last_toggle_direction_open: bool
    @property
    def current_cover_position(self) -> Union[int, None]: ...
    @property
    def current_cover_tilt_position(self) -> Union[int, None]: ...
    @property
    def device_class(self) -> Union[CoverDeviceClass, str, None]: ...
    @property
    def state(self) -> Union[str, None]: ...
    @property
    def state_attributes(self): ...
    @property
    def supported_features(self) -> int: ...
    @property
    def is_opening(self) -> Union[bool, None]: ...
    @property
    def is_closing(self) -> Union[bool, None]: ...
    @property
    def is_closed(self) -> Union[bool, None]: ...
    def open_cover(self, **kwargs: Any) -> None: ...
    async def async_open_cover(self, **kwargs) -> None: ...
    def close_cover(self, **kwargs: Any) -> None: ...
    async def async_close_cover(self, **kwargs) -> None: ...
    def toggle(self, **kwargs: Any) -> None: ...
    async def async_toggle(self, **kwargs) -> None: ...
    def set_cover_position(self, **kwargs) -> None: ...
    async def async_set_cover_position(self, **kwargs) -> None: ...
    def stop_cover(self, **kwargs) -> None: ...
    async def async_stop_cover(self, **kwargs) -> None: ...
    def open_cover_tilt(self, **kwargs: Any) -> None: ...
    async def async_open_cover_tilt(self, **kwargs) -> None: ...
    def close_cover_tilt(self, **kwargs: Any) -> None: ...
    async def async_close_cover_tilt(self, **kwargs) -> None: ...
    def set_cover_tilt_position(self, **kwargs) -> None: ...
    async def async_set_cover_tilt_position(self, **kwargs) -> None: ...
    def stop_cover_tilt(self, **kwargs) -> None: ...
    async def async_stop_cover_tilt(self, **kwargs) -> None: ...
    def toggle_tilt(self, **kwargs: Any) -> None: ...
    async def async_toggle_tilt(self, **kwargs) -> None: ...
    def _get_toggle_function(self, fns): ...

class CoverDevice(CoverEntity):
    def __init_subclass__(cls, **kwargs) -> None: ...
