from .const import DEFAULT_DEVICE_NAME as DEFAULT_DEVICE_NAME, DEFAULT_HOST as DEFAULT_HOST, DEFAULT_PORT as DEFAULT_PORT, DEFAULT_USERNAME as DEFAULT_USERNAME, DOMAIN as DOMAIN, SERVICE_CLEANUP as SERVICE_CLEANUP, SERVICE_REBOOT as SERVICE_REBOOT, SERVICE_RECONNECT as SERVICE_RECONNECT, TRACKER_SCAN_INTERVAL as TRACKER_SCAN_INTERVAL
from collections.abc import Callable as Callable, ValuesView
from datetime import datetime
from homeassistant.components.device_tracker.const import CONF_CONSIDER_HOME as CONF_CONSIDER_HOME, DEFAULT_CONSIDER_HOME as DEFAULT_CONSIDER_HOME
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.core import CALLBACK_TYPE as CALLBACK_TYPE, HomeAssistant as HomeAssistant, ServiceCall as ServiceCall, callback as callback
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers.device_registry import CONNECTION_NETWORK_MAC as CONNECTION_NETWORK_MAC, async_entries_for_config_entry as async_entries_for_config_entry, async_get as async_get
from homeassistant.helpers.dispatcher import async_dispatcher_connect as async_dispatcher_connect, dispatcher_send as dispatcher_send
from homeassistant.helpers.entity import DeviceInfo as DeviceInfo, Entity as Entity
from homeassistant.helpers.entity_registry import EntityRegistry as EntityRegistry, RegistryEntry as RegistryEntry, async_entries_for_device as async_entries_for_device
from homeassistant.helpers.event import async_track_time_interval as async_track_time_interval
from types import MappingProxyType
from typing import Any, TypedDict

_LOGGER: Any

def _is_tracked(mac: str, current_devices: ValuesView) -> bool: ...
def device_filter_out_from_trackers(mac: str, device: FritzDevice, current_devices: ValuesView) -> bool: ...
def _cleanup_entity_filter(device: RegistryEntry) -> bool: ...

class ClassSetupMissing(Exception):
    def __init__(self) -> None: ...

class Device:
    mac: str
    ip_address: str
    name: str

class HostInfo(TypedDict):
    mac: str
    name: str
    ip: str
    status: bool

class FritzBoxTools:
    _cancel_scan: Any
    _devices: Any
    _options: Any
    _unique_id: Any
    connection: Any
    fritz_hosts: Any
    fritz_status: Any
    hass: Any
    host: Any
    password: Any
    port: Any
    username: Any
    _mac: Any
    _model: Any
    _current_firmware: Any
    _latest_firmware: Any
    _update_available: bool
    def __init__(self, hass: HomeAssistant, password: str, username: str = ..., host: str = ..., port: int = ...) -> None: ...
    async def async_setup(self) -> None: ...
    def setup(self) -> None: ...
    async def async_start(self, options: MappingProxyType[str, Any]) -> None: ...
    def async_unload(self) -> None: ...
    @property
    def unique_id(self) -> str: ...
    @property
    def model(self) -> str: ...
    @property
    def current_firmware(self) -> str: ...
    @property
    def latest_firmware(self) -> Union[str, None]: ...
    @property
    def update_available(self) -> bool: ...
    @property
    def mac(self) -> str: ...
    @property
    def devices(self) -> dict[str, FritzDevice]: ...
    @property
    def signal_device_new(self) -> str: ...
    @property
    def signal_device_update(self) -> str: ...
    def _update_hosts_info(self) -> list[HostInfo]: ...
    def _update_device_info(self) -> tuple[bool, Union[str, None]]: ...
    def scan_devices(self, now: Union[datetime, None] = ...) -> None: ...
    async def service_fritzbox(self, service_call: ServiceCall, config_entry: ConfigEntry) -> None: ...
    def _async_remove_empty_devices(self, entity_reg: EntityRegistry, config_entry: ConfigEntry) -> None: ...

class FritzData:
    tracked: dict
    profile_switches: dict

class FritzDeviceBase(Entity):
    _router: Any
    _mac: Any
    _name: Any
    def __init__(self, router: FritzBoxTools, device: FritzDevice) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def ip_address(self) -> Union[str, None]: ...
    @property
    def mac_address(self) -> str: ...
    @property
    def hostname(self) -> Union[str, None]: ...
    @property
    def device_info(self) -> DeviceInfo: ...
    @property
    def should_poll(self) -> bool: ...
    async def async_process_update(self) -> None: ...
    async def async_on_demand_update(self) -> None: ...
    async def async_added_to_hass(self) -> None: ...

class FritzDevice:
    _mac: Any
    _name: Any
    _ip_address: Any
    _last_activity: Any
    _connected: bool
    def __init__(self, mac: str, name: str) -> None: ...
    def update(self, dev_info: Device, dev_home: bool, consider_home: float) -> None: ...
    @property
    def is_connected(self) -> bool: ...
    @property
    def mac_address(self) -> str: ...
    @property
    def hostname(self) -> str: ...
    @property
    def ip_address(self) -> Union[str, None]: ...
    @property
    def last_activity(self) -> Union[datetime, None]: ...

class SwitchInfo(TypedDict):
    description: str
    friendly_name: str
    icon: str
    type: str
    callback_update: Callable
    callback_switch: Callable

class FritzBoxBaseEntity:
    _fritzbox_tools: Any
    _device_name: Any
    def __init__(self, fritzbox_tools: FritzBoxTools, device_name: str) -> None: ...
    @property
    def mac_address(self) -> str: ...
    @property
    def device_info(self) -> DeviceInfo: ...
