import logging
from .const import CHILD_CALLBACK as CHILD_CALLBACK, CONF_DEVICE as CONF_DEVICE, DOMAIN as DOMAIN, DevId as DevId, GatewayId as GatewayId, NODE_CALLBACK as NODE_CALLBACK, PLATFORM_TYPES as PLATFORM_TYPES, UPDATE_DELAY as UPDATE_DELAY
from homeassistant.const import ATTR_BATTERY_LEVEL as ATTR_BATTERY_LEVEL, STATE_OFF as STATE_OFF, STATE_ON as STATE_ON
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.helpers.dispatcher import async_dispatcher_connect as async_dispatcher_connect
from homeassistant.helpers.entity import DeviceInfo as DeviceInfo, Entity as Entity
from mysensors import BaseAsyncGateway as BaseAsyncGateway, Sensor as Sensor
from mysensors.sensor import ChildSensor as ChildSensor
from typing import Any

_LOGGER: Any
ATTR_CHILD_ID: str
ATTR_DESCRIPTION: str
ATTR_DEVICE: str
ATTR_NODE_ID: str
ATTR_HEARTBEAT: str
MYSENSORS_PLATFORM_DEVICES: str

class MySensorsDevice:
    hass: HomeAssistant
    gateway_id: Any
    gateway: Any
    node_id: Any
    child_id: Any
    value_type: Any
    child_type: Any
    _values: Any
    _update_scheduled: bool
    def __init__(self, gateway_id: GatewayId, gateway: BaseAsyncGateway, node_id: int, child_id: int, value_type: int) -> None: ...
    @property
    def dev_id(self) -> DevId: ...
    @property
    def _logger(self) -> logging.Logger: ...
    async def async_will_remove_from_hass(self) -> None: ...
    @property
    def _node(self) -> Sensor: ...
    @property
    def _child(self) -> ChildSensor: ...
    @property
    def sketch_name(self) -> str: ...
    @property
    def sketch_version(self) -> str: ...
    @property
    def node_name(self) -> str: ...
    @property
    def unique_id(self) -> str: ...
    @property
    def device_info(self) -> DeviceInfo: ...
    @property
    def name(self) -> str: ...
    @property
    def _extra_attributes(self) -> dict[str, Any]: ...
    async def async_update(self) -> None: ...
    async def _async_update_callback(self) -> None: ...
    def async_update_callback(self) -> None: ...

def get_mysensors_devices(hass: HomeAssistant, domain: str) -> dict[DevId, MySensorsDevice]: ...

class MySensorsEntity(MySensorsDevice, Entity):
    @property
    def should_poll(self) -> bool: ...
    @property
    def available(self) -> bool: ...
    @property
    def extra_state_attributes(self) -> dict[str, Any]: ...
    async def _async_update_callback(self) -> None: ...
    async def async_added_to_hass(self) -> None: ...
