from . import SynoApi as SynoApi, SynologyDSMBaseEntity as SynologyDSMBaseEntity
from .const import COORDINATOR_CAMERAS as COORDINATOR_CAMERAS, DOMAIN as DOMAIN, SYNO_API as SYNO_API, SynologyDSMEntityDescription as SynologyDSMEntityDescription
from homeassistant.components.camera import Camera as Camera, CameraEntityDescription as CameraEntityDescription, SUPPORT_STREAM as SUPPORT_STREAM
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.helpers.entity import DeviceInfo as DeviceInfo
from homeassistant.helpers.entity_platform import AddEntitiesCallback as AddEntitiesCallback
from homeassistant.helpers.update_coordinator import DataUpdateCoordinator as DataUpdateCoordinator
from synology_dsm.api.surveillance_station import SynoCamera as SynoCamera
from typing import Any

_LOGGER: Any

class SynologyDSMCameraEntityDescription(CameraEntityDescription, SynologyDSMEntityDescription): ...

async def async_setup_entry(hass: HomeAssistant, entry: ConfigEntry, async_add_entities: AddEntitiesCallback) -> None: ...

class SynoDSMCamera(SynologyDSMBaseEntity, Camera):
    coordinator: DataUpdateCoordinator[dict[str, dict[str, SynoCamera]]]
    entity_description: SynologyDSMCameraEntityDescription
    def __init__(self, api: SynoApi, coordinator: DataUpdateCoordinator[dict[str, dict[str, SynoCamera]]], camera_id: str) -> None: ...
    @property
    def camera_data(self) -> SynoCamera: ...
    @property
    def device_info(self) -> DeviceInfo: ...
    @property
    def available(self) -> bool: ...
    @property
    def supported_features(self) -> int: ...
    @property
    def is_recording(self) -> bool: ...
    @property
    def motion_detection_enabled(self) -> bool: ...
    def camera_image(self, width: Union[int, None] = ..., height: Union[int, None] = ...) -> Union[bytes, None]: ...
    async def stream_source(self) -> Union[str, None]: ...
    def enable_motion_detection(self) -> None: ...
    def disable_motion_detection(self) -> None: ...
