from .core import Context as Context
from collections.abc import Generator, Sequence
from typing import Any

class HomeAssistantError(Exception): ...
class InvalidEntityFormatError(HomeAssistantError): ...
class NoEntitySpecifiedError(HomeAssistantError): ...

class TemplateError(HomeAssistantError):
    def __init__(self, exception: Exception) -> None: ...

class ConditionError(HomeAssistantError):
    type: str
    @staticmethod
    def _indent(indent: int, message: str) -> str: ...
    def output(self, indent: int) -> Generator[str, None, None]: ...
    def __str__(self) -> str: ...
    def __init__(self, type) -> None: ...
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __gt__(self, other): ...
    def __ge__(self, other): ...

class ConditionErrorMessage(ConditionError):
    message: str
    def output(self, indent: int) -> Generator[str, None, None]: ...
    def __init__(self, type, message) -> None: ...
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __gt__(self, other): ...
    def __ge__(self, other): ...

class ConditionErrorIndex(ConditionError):
    index: int
    total: int
    error: ConditionError
    def output(self, indent: int) -> Generator[str, None, None]: ...
    def __init__(self, type, index, total, error) -> None: ...
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __gt__(self, other): ...
    def __ge__(self, other): ...

class ConditionErrorContainer(ConditionError):
    errors: Sequence[ConditionError]
    def output(self, indent: int) -> Generator[str, None, None]: ...
    def __init__(self, type, errors) -> None: ...
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __gt__(self, other): ...
    def __ge__(self, other): ...

class IntegrationError(HomeAssistantError):
    def __str__(self) -> str: ...

class PlatformNotReady(IntegrationError): ...
class ConfigEntryNotReady(IntegrationError): ...
class ConfigEntryAuthFailed(IntegrationError): ...
class InvalidStateError(HomeAssistantError): ...

class Unauthorized(HomeAssistantError):
    context: Any
    user_id: Any
    entity_id: Any
    config_entry_id: Any
    perm_category: Any
    permission: Any
    def __init__(self, context: Union[Context, None] = ..., user_id: Union[str, None] = ..., entity_id: Union[str, None] = ..., config_entry_id: Union[str, None] = ..., perm_category: Union[str, None] = ..., permission: Union[str, None] = ...) -> None: ...

class UnknownUser(Unauthorized): ...

class ServiceNotFound(HomeAssistantError):
    domain: Any
    service: Any
    def __init__(self, domain: str, service: str) -> None: ...
    def __str__(self) -> str: ...

class MaxLengthExceeded(HomeAssistantError):
    value: Any
    property_name: Any
    max_length: Any
    def __init__(self, value: str, property_name: str, max_length: int) -> None: ...

class RequiredParameterMissing(HomeAssistantError):
    parameter_names: Any
    def __init__(self, parameter_names: list[str]) -> None: ...
