import logging
import voluptuous as vol
from .entity_platform import EntityPlatform as EntityPlatform
from collections.abc import Callable as Callable, Iterable
from datetime import timedelta
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.const import CONF_ENTITY_NAMESPACE as CONF_ENTITY_NAMESPACE, CONF_SCAN_INTERVAL as CONF_SCAN_INTERVAL, EVENT_HOMEASSISTANT_STOP as EVENT_HOMEASSISTANT_STOP
from homeassistant.core import Event as Event, HomeAssistant as HomeAssistant, ServiceCall as ServiceCall, callback as callback
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers import config_per_platform as config_per_platform, discovery as discovery, entity as entity, service as service
from homeassistant.helpers.typing import ConfigType as ConfigType, DiscoveryInfoType as DiscoveryInfoType
from homeassistant.loader import async_get_integration as async_get_integration, bind_hass as bind_hass
from homeassistant.setup import async_prepare_setup_platform as async_prepare_setup_platform
from types import ModuleType
from typing import Any

DEFAULT_SCAN_INTERVAL: Any
DATA_INSTANCES: str

async def async_update_entity(hass: HomeAssistant, entity_id: str) -> None: ...

class EntityComponent:
    logger: Any
    hass: Any
    domain: Any
    scan_interval: Any
    config: Any
    _platforms: Any
    async_add_entities: Any
    add_entities: Any
    def __init__(self, logger: logging.Logger, domain: str, hass: HomeAssistant, scan_interval: timedelta = ...) -> None: ...
    @property
    def entities(self) -> Iterable[entity.Entity]: ...
    def get_entity(self, entity_id: str) -> Union[entity.Entity, None]: ...
    def setup(self, config: ConfigType) -> None: ...
    async def async_setup(self, config: ConfigType) -> None: ...
    async def async_setup_entry(self, config_entry: ConfigEntry) -> bool: ...
    async def async_unload_entry(self, config_entry: ConfigEntry) -> bool: ...
    async def async_extract_from_service(self, service_call: ServiceCall, expand_group: bool = ...) -> list[entity.Entity]: ...
    def async_register_entity_service(self, name: str, schema: Union[dict[str, Any], vol.Schema], func: Union[str, Callable[..., Any]], required_features: Union[list[int], None] = ...) -> None: ...
    async def async_setup_platform(self, platform_type: str, platform_config: ConfigType, discovery_info: Union[DiscoveryInfoType, None] = ...) -> None: ...
    async def _async_reset(self) -> None: ...
    async def async_remove_entity(self, entity_id: str) -> None: ...
    async def async_prepare_reload(self, *, skip_reset: bool = ...) -> Union[ConfigType, None]: ...
    def _async_init_entity_platform(self, platform_type: str, platform: Union[ModuleType, None], scan_interval: Union[timedelta, None] = ..., entity_namespace: Union[str, None] = ...) -> EntityPlatform: ...
    async def _async_shutdown(self, event: Event) -> None: ...
