from .typing import UNDEFINED as UNDEFINED, UndefinedType as UndefinedType
from collections import UserDict
from collections.abc import Callable as Callable, Iterable, Mapping
from homeassistant.backports.enum import StrEnum as StrEnum
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.const import ATTR_DEVICE_CLASS as ATTR_DEVICE_CLASS, ATTR_FRIENDLY_NAME as ATTR_FRIENDLY_NAME, ATTR_ICON as ATTR_ICON, ATTR_RESTORED as ATTR_RESTORED, ATTR_SUPPORTED_FEATURES as ATTR_SUPPORTED_FEATURES, ATTR_UNIT_OF_MEASUREMENT as ATTR_UNIT_OF_MEASUREMENT, EVENT_HOMEASSISTANT_START as EVENT_HOMEASSISTANT_START, MAX_LENGTH_STATE_DOMAIN as MAX_LENGTH_STATE_DOMAIN, MAX_LENGTH_STATE_ENTITY_ID as MAX_LENGTH_STATE_ENTITY_ID, STATE_UNAVAILABLE as STATE_UNAVAILABLE
from homeassistant.core import Event as Event, HomeAssistant as HomeAssistant, callback as callback, split_entity_id as split_entity_id, valid_entity_id as valid_entity_id
from homeassistant.exceptions import MaxLengthExceeded as MaxLengthExceeded
from homeassistant.helpers import storage as storage
from homeassistant.helpers.device_registry import EVENT_DEVICE_REGISTRY_UPDATED as EVENT_DEVICE_REGISTRY_UPDATED
from homeassistant.helpers.frame import report as report
from homeassistant.loader import bind_hass as bind_hass
from homeassistant.util import slugify as slugify
from homeassistant.util.yaml import load_yaml as load_yaml
from typing import Any

PATH_REGISTRY: str
DATA_REGISTRY: str
EVENT_ENTITY_REGISTRY_UPDATED: str
SAVE_DELAY: int
_LOGGER: Any
STORAGE_VERSION_MAJOR: int
STORAGE_VERSION_MINOR: int
STORAGE_KEY: str
ENTITY_DESCRIBING_ATTRIBUTES: Any

class RegistryEntryDisabler(StrEnum):
    CONFIG_ENTRY: str
    DEVICE: str
    HASS: str
    INTEGRATION: str
    USER: str

DISABLED_CONFIG_ENTRY: Any
DISABLED_DEVICE: Any
DISABLED_HASS: Any
DISABLED_INTEGRATION: Any
DISABLED_USER: Any

class RegistryEntry:
    entity_id: str
    unique_id: str
    platform: str
    area_id: Union[str, None]
    capabilities: Union[Mapping[str, Any], None]
    config_entry_id: Union[str, None]
    device_class: Union[str, None]
    device_id: Union[str, None]
    domain: str
    disabled_by: Union[RegistryEntryDisabler, None]
    entity_category: Union[str, None]
    icon: Union[str, None]
    id: str
    name: Union[str, None]
    original_device_class: Union[str, None]
    original_icon: Union[str, None]
    original_name: Union[str, None]
    supported_features: int
    unit_of_measurement: Union[str, None]
    def _domain_default(self) -> str: ...
    @property
    def disabled(self) -> bool: ...
    def write_unavailable_state(self, hass: HomeAssistant) -> None: ...
    def __init__(self, entity_id, unique_id, platform, area_id, capabilities, config_entry_id, device_class, device_id, domain, disabled_by, entity_category, icon, id, name, original_device_class, original_icon, original_name, supported_features, unit_of_measurement) -> None: ...
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __gt__(self, other): ...
    def __ge__(self, other): ...

class EntityRegistryStore(storage.Store):
    async def _async_migrate_func(self, old_major_version: int, old_minor_version: int, old_data: dict) -> dict: ...

class EntityRegistryItems(UserDict):
    _entry_ids: Any
    _index: Any
    def __init__(self) -> None: ...
    def __setitem__(self, key: str, entry: RegistryEntry) -> None: ...
    def __delitem__(self, key: str) -> None: ...
    def __getitem__(self, key: str) -> RegistryEntry: ...
    def get_entity_id(self, key: tuple[str, str, str]) -> Union[str, None]: ...
    def get_entry(self, key: str) -> Union[RegistryEntry, None]: ...

class EntityRegistry:
    hass: Any
    entities: Any
    _store: Any
    def __init__(self, hass: HomeAssistant) -> None: ...
    def async_get_device_class_lookup(self, domain_device_classes: set[tuple[str, Union[str, None]]]) -> dict: ...
    def async_is_registered(self, entity_id: str) -> bool: ...
    def async_get(self, entity_id: str) -> Union[RegistryEntry, None]: ...
    def async_get_entity_id(self, domain: str, platform: str, unique_id: str) -> Union[str, None]: ...
    def async_generate_entity_id(self, domain: str, suggested_object_id: str, known_object_ids: Union[Iterable[str], None] = ...) -> str: ...
    def async_get_or_create(self, domain: str, platform: str, unique_id: str, *, known_object_ids: Union[Iterable[str], None] = ..., suggested_object_id: Union[str, None] = ..., disabled_by: Union[RegistryEntryDisabler, None] = ..., area_id: Union[str, None] = ..., capabilities: Union[Mapping[str, Any], None] = ..., config_entry: Union[ConfigEntry, None] = ..., device_id: Union[str, None] = ..., entity_category: Union[str, None] = ..., original_device_class: Union[str, None] = ..., original_icon: Union[str, None] = ..., original_name: Union[str, None] = ..., supported_features: Union[int, None] = ..., unit_of_measurement: Union[str, None] = ...) -> RegistryEntry: ...
    def async_remove(self, entity_id: str) -> None: ...
    def async_device_modified(self, event: Event) -> None: ...
    def async_update_entity(self, entity_id: str, *, area_id: Union[str, None, UndefinedType] = ..., config_entry_id: Union[str, None, UndefinedType] = ..., device_class: Union[str, None, UndefinedType] = ..., disabled_by: Union[RegistryEntryDisabler, None, UndefinedType] = ..., entity_category: Union[str, None, UndefinedType] = ..., icon: Union[str, None, UndefinedType] = ..., name: Union[str, None, UndefinedType] = ..., new_entity_id: Union[str, UndefinedType] = ..., new_unique_id: Union[str, UndefinedType] = ..., original_device_class: Union[str, None, UndefinedType] = ..., original_icon: Union[str, None, UndefinedType] = ..., original_name: Union[str, None, UndefinedType] = ..., unit_of_measurement: Union[str, None, UndefinedType] = ...) -> RegistryEntry: ...
    def _async_update_entity(self, entity_id: str, *, area_id: Union[str, None, UndefinedType] = ..., capabilities: Union[Mapping[str, Any], None, UndefinedType] = ..., config_entry_id: Union[str, None, UndefinedType] = ..., device_class: Union[str, None, UndefinedType] = ..., device_id: Union[str, None, UndefinedType] = ..., disabled_by: Union[RegistryEntryDisabler, None, UndefinedType] = ..., entity_category: Union[str, None, UndefinedType] = ..., icon: Union[str, None, UndefinedType] = ..., name: Union[str, None, UndefinedType] = ..., new_entity_id: Union[str, UndefinedType] = ..., new_unique_id: Union[str, UndefinedType] = ..., original_device_class: Union[str, None, UndefinedType] = ..., original_icon: Union[str, None, UndefinedType] = ..., original_name: Union[str, None, UndefinedType] = ..., supported_features: Union[int, UndefinedType] = ..., unit_of_measurement: Union[str, None, UndefinedType] = ...) -> RegistryEntry: ...
    async def async_load(self) -> None: ...
    def async_schedule_save(self) -> None: ...
    def _data_to_save(self) -> dict[str, Any]: ...
    def async_clear_config_entry(self, config_entry: str) -> None: ...
    def async_clear_area_id(self, area_id: str) -> None: ...

def async_get(hass: HomeAssistant) -> EntityRegistry: ...
async def async_load(hass: HomeAssistant) -> None: ...
async def async_get_registry(hass: HomeAssistant) -> EntityRegistry: ...
def async_entries_for_device(registry: EntityRegistry, device_id: str, include_disabled_entities: bool = ...) -> list[RegistryEntry]: ...
def async_entries_for_area(registry: EntityRegistry, area_id: str) -> list[RegistryEntry]: ...
def async_entries_for_config_entry(registry: EntityRegistry, config_entry_id: str) -> list[RegistryEntry]: ...
def async_config_entry_disabled_by_changed(registry: EntityRegistry, config_entry: ConfigEntry) -> None: ...
async def _async_migrate(old_major_version: int, old_minor_version: int, data: dict) -> dict: ...
async def _async_migrate_yaml_to_json(entities: dict[str, Any]) -> dict[str, list[dict[str, Any]]]: ...
def async_setup_entity_restore(hass: HomeAssistant, registry: EntityRegistry) -> None: ...
async def async_migrate_entries(hass: HomeAssistant, config_entry_id: str, entry_callback: Callable[[RegistryEntry], Union[dict, None]]) -> None: ...
def async_resolve_entity_ids(registry: EntityRegistry, entity_ids_or_uuids: list[str]) -> list[str]: ...
