from datetime import datetime
from homeassistant.const import EVENT_HOMEASSISTANT_STOP as EVENT_HOMEASSISTANT_STOP
from homeassistant.core import HomeAssistant as HomeAssistant, State as State, callback as callback, valid_entity_id as valid_entity_id
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers import entity_registry as entity_registry, start as start
from homeassistant.helpers.entity import Entity as Entity
from homeassistant.helpers.event import async_track_time_interval as async_track_time_interval
from homeassistant.helpers.json import JSONEncoder as JSONEncoder
from homeassistant.helpers.singleton import singleton as singleton
from homeassistant.helpers.storage import Store as Store
from typing import Any

DATA_RESTORE_STATE_TASK: str
_LOGGER: Any
STORAGE_KEY: str
STORAGE_VERSION: int
STATE_DUMP_INTERVAL: Any
STATE_EXPIRATION: Any

class StoredState:
    state: Any
    last_seen: Any
    def __init__(self, state: State, last_seen: datetime) -> None: ...
    def as_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_dict(cls, json_dict: dict) -> StoredState: ...

class RestoreStateData:
    @staticmethod
    async def async_get_instance(hass: HomeAssistant) -> RestoreStateData: ...
    @classmethod
    async def async_save_persistent_states(cls, hass: HomeAssistant) -> None: ...
    hass: Any
    store: Any
    last_states: Any
    entity_ids: Any
    def __init__(self, hass: HomeAssistant) -> None: ...
    def async_get_stored_states(self) -> list[StoredState]: ...
    async def async_dump_states(self) -> None: ...
    def async_setup_dump(self, *args: Any) -> None: ...
    def async_restore_entity_added(self, entity_id: str) -> None: ...
    def async_restore_entity_removed(self, entity_id: str) -> None: ...

def _encode(value: Any) -> Any: ...
def _encode_complex(value: Any) -> Any: ...

class RestoreEntity(Entity):
    async def async_internal_added_to_hass(self) -> None: ...
    async def async_internal_will_remove_from_hass(self) -> None: ...
    async def async_get_last_state(self) -> Union[State, None]: ...
