from collections import deque
from collections.abc import Callable as Callable, Generator
from contextvars import ContextVar
from homeassistant.helpers.typing import TemplateVarsType as TemplateVarsType
from typing import Any

class TraceElement:
    _child_key: Any
    _child_run_id: Any
    _error: Any
    path: Any
    _result: Any
    reuse_by_child: bool
    _timestamp: Any
    _variables: Any
    def __init__(self, variables: TemplateVarsType, path: str) -> None: ...
    def __repr__(self) -> str: ...
    def set_child_id(self, child_key: str, child_run_id: str) -> None: ...
    def set_error(self, ex: Exception) -> None: ...
    def set_result(self, **kwargs: Any) -> None: ...
    def update_result(self, **kwargs: Any) -> None: ...
    def as_dict(self) -> dict[str, Any]: ...

trace_cv: ContextVar[Union[dict[str, deque[TraceElement]], None]]
trace_stack_cv: ContextVar[Union[list[TraceElement], None]]
trace_path_stack_cv: ContextVar[Union[list[str], None]]
variables_cv: ContextVar[Union[Any, None]]
trace_id_cv: ContextVar[Union[tuple[str, str], None]]
script_execution_cv: ContextVar[Union[StopReason, None]]

def trace_id_set(trace_id: tuple[str, str]) -> None: ...
def trace_id_get() -> Union[tuple[str, str], None]: ...
def trace_stack_push(trace_stack_var: ContextVar, node: Any) -> None: ...
def trace_stack_pop(trace_stack_var: ContextVar) -> None: ...
def trace_stack_top(trace_stack_var: ContextVar) -> Union[Any, None]: ...
def trace_path_push(suffix: Union[str, list[str]]) -> int: ...
def trace_path_pop(count: int) -> None: ...
def trace_path_get() -> str: ...
def trace_append_element(trace_element: TraceElement, maxlen: Union[int, None] = ...) -> None: ...
def trace_get(clear: bool = ...) -> Union[dict[str, deque[TraceElement]], None]: ...
def trace_clear() -> None: ...
def trace_set_child_id(child_key: str, child_run_id: str) -> None: ...
def trace_set_result(**kwargs: Any) -> None: ...
def trace_update_result(**kwargs: Any) -> None: ...

class StopReason:
    script_execution: Union[str, None]

def script_execution_set(reason: str) -> None: ...
def script_execution_get() -> Union[str, None]: ...
def trace_path(suffix: Union[str, list[str]]) -> Generator: ...
def async_trace_path(suffix: Union[str, list[str]]) -> Callable: ...
