"""

Revision ID: b76079e9845f
Revises: bf6b86dd5463
Create Date: 2025-07-12 21:32:08.865721

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision: str = "b76079e9845f"
down_revision: Union[str, None] = "bf6b86dd5463"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###

    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(sa.Column("momentum_time_span", sa.Date(), nullable=True))
        batch_op.create_index(
            "ix_analysis_momentum_time_span", ["momentum_time_span"], unique=False
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index("ix_analysis_momentum_time_span")
        batch_op.drop_column("momentum_time_span")

    # ### end Alembic commands ###
