# The Diversity in Conversational AI Evaluation for Safety (**DICES**) dataset

Machine learning approaches are often trained and evaluated with datasets that
require a clear separation between positive and negative examples. This approach
overly simplifies the natural subjectivity present in many tasks and content
items. It also obscures the inherent diversity in human perceptions and
opinions. Often tasks that attempt to preserve the variance in content and
diversity in humans are quite expensive and laborious. To fill in this gap and
facilitate more in-depth model performance analyses we propose the DICES dataset
- a unique dataset with diverse perspectives on safety of AI generated
conversations. We focus on the task of safety evaluation of conversational AI
systems. The DICES dataset contains detailed demographics information about each
rater, extremely high replication of unique ratings per conversation to ensure
statistical significance of further analyses and encodes rater votes as
distributions across different demographics to allow for in-depth explorations
of different rating aggregation strategies.

This dataset is well suited to observe and measure variance, ambiguity and
diversity in the context of safety of conversational AI. The dataset is
accompanied by a paper describing a set of metrics that show how rater diversity
influences the safety perception of raters from different geographic regions,
ethnicity groups, age groups and genders. The goal of the DICES dataset is to be
used as a shared benchmark for safety evaluation of conversational AI systems.

**CONTENT WARNING**: This dataset contains adversarial examples of conversations
that may be offensive.

