# coding: utf-8

"""


No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing_extensions import Self


class ActionSummary(BaseModel):
    """
    ActionSummary
    """  # noqa: E501

    name: StrictStr = Field(description="The name of the action (v1) or step (v2)")
    action_type: StrictStr = Field(description="The action_type (v1) or task (v2)")
    status: Optional[StrictStr] = Field(
        default=None, description="The status of the action"
    )
    task_id: Optional[StrictStr] = Field(
        default=None,
        description="The ID of the workflow task for this action, if it exists",
    )
    run_id: Optional[StrictStr] = Field(
        default=None,
        description="The ID of the workflow run for this action, if it exists",
    )
    previous_run_manifest_id: Optional[StrictStr] = Field(
        default=None,
        description="(V1 workflows only) The ID of the workflow run that should be used for checkpoint data. This is usually the ID of the most recent successfully completed run (or empty if there are no previous completed runs for this workflow). However, in the case of retrying failures, this will be the ID of the run being retried for failed actions so that it can pick up partial state from the previous attempt.",
    )
    input_run_manifest_id: Optional[StrictStr] = Field(
        default=None,
        description='(V1 workflows only) The ID of the workflow run containing the input action run manifest to use. This is usually the ID of the workflow run to which both "this" action being summarized and its input belong. However, in the case of retrying failures, this field will reference the ID of the workflow run being retried if "this" action\'s input was successful in that previous run and thus skipped in this one. This field is empty for actions that do not take any input.',
    )
    step_checkpoint_source: Optional[StrictStr] = Field(
        default=None,
        description='(V2 workflows only) The ID of the workflow run containing partial output from a previous attempt of "this" step being summarized.',
    )
    execution_summary: Optional[Dict[str, Any]] = Field(
        default=None, description="Metadata provided by the task as an output"
    )
    __properties: ClassVar[List[str]] = [
        "name",
        "action_type",
        "status",
        "task_id",
        "run_id",
        "previous_run_manifest_id",
        "input_run_manifest_id",
        "step_checkpoint_source",
        "execution_summary",
    ]

    @field_validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(
            [
                "RUN_STATUS_UNKNOWN",
                "RUN_STATUS_CREATED",
                "RUN_STATUS_PENDING",
                "RUN_STATUS_ACTIVE",
                "RUN_STATUS_ERROR",
                "RUN_STATUS_LOST",
                "RUN_STATUS_COMPLETED",
                "RUN_STATUS_CANCELLING",
                "RUN_STATUS_CANCELLED",
                "RUN_STATUS_SKIPPED",
            ]
        ):
            raise ValueError(
                "must be one of enum values ('RUN_STATUS_UNKNOWN', 'RUN_STATUS_CREATED', 'RUN_STATUS_PENDING', 'RUN_STATUS_ACTIVE', 'RUN_STATUS_ERROR', 'RUN_STATUS_LOST', 'RUN_STATUS_COMPLETED', 'RUN_STATUS_CANCELLING', 'RUN_STATUS_CANCELLED', 'RUN_STATUS_SKIPPED')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ActionSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ActionSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "action_type": obj.get("action_type"),
                "status": obj.get("status"),
                "task_id": obj.get("task_id"),
                "run_id": obj.get("run_id"),
                "previous_run_manifest_id": obj.get("previous_run_manifest_id"),
                "input_run_manifest_id": obj.get("input_run_manifest_id"),
                "step_checkpoint_source": obj.get("step_checkpoint_source"),
                "execution_summary": obj.get("execution_summary"),
            }
        )
        return _obj
