# coding: utf-8

"""


No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing_extensions import Self


class ConfigAsymmetricKeyMetadata(BaseModel):
    """
    ConfigAsymmetricKeyMetadata
    """  # noqa: E501

    key_id: Optional[StrictStr] = Field(
        default=None,
        description="A string to allow identifying the key used for decryption. This may reference a resource within a cloud provider; however, clients may treat this as a fully opaque value.",
    )
    algorithm: Optional[StrictStr] = Field(
        default=None,
        description="The asymmetric decryption algorithm to use with this key.",
    )
    public_key_pem: Optional[StrictStr] = Field(
        default=None, description="PEM-encoded public key."
    )
    __properties: ClassVar[List[str]] = ["key_id", "algorithm", "public_key_pem"]

    @field_validator("algorithm")
    def algorithm_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["UNKNOWN_ALGORITHM", "RSA_4096_OAEP_SHA256"]):
            raise ValueError(
                "must be one of enum values ('UNKNOWN_ALGORITHM', 'RSA_4096_OAEP_SHA256')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConfigAsymmetricKeyMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConfigAsymmetricKeyMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "key_id": obj.get("key_id"),
                "algorithm": obj.get("algorithm"),
                "public_key_pem": obj.get("public_key_pem"),
            }
        )
        return _obj
