# coding: utf-8

"""


No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictBool,
    StrictStr,
    field_validator,
)
from typing_extensions import Self


class Connection(BaseModel):
    """
    Next available tag: 14
    """  # noqa: E501

    id: StrictStr = Field(
        description="The id of the connection. Connection id's are prefixed with `c_`."
    )
    type: StrictStr = Field(description="Type of the connection: aws, gcs, azure etc.")
    name: StrictStr = Field(description="Name of the connection.")
    validation_status: StrictStr = Field(
        description="Current connection validation status. Possible values are: `COMPLETED`, `ERROR`, or `NONE`."
    )
    credentials: Optional[Dict[str, Any]] = Field(
        default=None, description="Connection credentials in plain text."
    )
    config: Optional[Dict[str, Any]] = Field(
        default=None,
        description="The connection configuration. See [connection type documentation](https://docs.gretel.ai/create-synthetic-data/workflows-and-connectors/connectors) for structure.",
    )
    encrypted_credentials: Optional[Dict[str, Any]] = Field(
        default=None, description="Connection credentials in encrypted form."
    )
    customer_managed_credentials_encryption: StrictBool = Field(
        description="When true, this connection is using a customer-managed key to encrypt credentials. Otherwise, this connection is using a Gretel-managed key to encrypt credentials."
    )
    created_at: datetime = Field(
        description="Timestamp when this connection was created."
    )
    project_id: StrictStr = Field(
        description="ID of the project that owns this connection"
    )
    created_by: StrictStr = Field(
        description="ID of the user who created this connection"
    )
    connection_target_type: Optional[StrictStr] = Field(
        default=None,
        description="The type of workflow action this connection may be used with. If empty or `unspecified`, this connection may be used with any workflow action. Possible values are: `source`, `destination`, `unspecified`",
    )
    auth_strategy: Optional[StrictStr] = Field(
        default=None,
        description="The auth strategy used when supported by a connection type. See [connection type documentation](https://docs.gretel.ai/create-synthetic-data/workflows-and-connectors/connectors) for possible values.",
    )
    __properties: ClassVar[List[str]] = [
        "id",
        "type",
        "name",
        "validation_status",
        "credentials",
        "config",
        "encrypted_credentials",
        "customer_managed_credentials_encryption",
        "created_at",
        "project_id",
        "created_by",
        "connection_target_type",
        "auth_strategy",
    ]

    @field_validator("validation_status")
    def validation_status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(
            [
                "VALIDATION_STATUS_UNKNOWN",
                "VALIDATION_STATUS_VALIDATING",
                "VALIDATION_STATUS_VALID",
                "VALIDATION_STATUS_INVALID",
            ]
        ):
            raise ValueError(
                "must be one of enum values ('VALIDATION_STATUS_UNKNOWN', 'VALIDATION_STATUS_VALIDATING', 'VALIDATION_STATUS_VALID', 'VALIDATION_STATUS_INVALID')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Connection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Connection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "type": obj.get("type"),
                "name": obj.get("name"),
                "validation_status": obj.get("validation_status"),
                "credentials": obj.get("credentials"),
                "config": obj.get("config"),
                "encrypted_credentials": obj.get("encrypted_credentials"),
                "customer_managed_credentials_encryption": obj.get(
                    "customer_managed_credentials_encryption"
                ),
                "created_at": obj.get("created_at"),
                "project_id": obj.get("project_id"),
                "created_by": obj.get("created_by"),
                "connection_target_type": obj.get("connection_target_type"),
                "auth_strategy": obj.get("auth_strategy"),
            }
        )
        return _obj
