# coding: utf-8

"""


No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr, field_validator
from typing_extensions import Self

from gretel_client.rest_v1.models.cluster import Cluster


class Project(BaseModel):
    """
    Project
    """  # noqa: E501

    id: Optional[StrictStr] = None
    uid: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    display_name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    long_description: Optional[StrictStr] = None
    owner: Optional[StrictStr] = None
    color: Optional[StrictStr] = None
    public: Optional[StrictBool] = None
    domain_guid: Optional[StrictStr] = None
    runner_mode: Optional[StrictStr] = None
    cluster_guid: Optional[StrictStr] = None
    cluster: Optional[Cluster] = None
    modified: Optional[datetime] = None
    created: Optional[datetime] = None
    __properties: ClassVar[List[str]] = [
        "id",
        "uid",
        "name",
        "display_name",
        "description",
        "long_description",
        "owner",
        "color",
        "public",
        "domain_guid",
        "runner_mode",
        "cluster_guid",
        "cluster",
        "modified",
        "created",
    ]

    @field_validator("runner_mode")
    def runner_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(
            [
                "RUNNER_MODE_UNSET",
                "RUNNER_MODE_CLOUD",
                "RUNNER_MODE_HYBRID",
                "RUNNER_MODE_INVALID",
            ]
        ):
            raise ValueError(
                "must be one of enum values ('RUNNER_MODE_UNSET', 'RUNNER_MODE_CLOUD', 'RUNNER_MODE_HYBRID', 'RUNNER_MODE_INVALID')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Project from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cluster
        if self.cluster:
            _dict["cluster"] = self.cluster.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Project from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "uid": obj.get("uid"),
                "name": obj.get("name"),
                "display_name": obj.get("display_name"),
                "description": obj.get("description"),
                "long_description": obj.get("long_description"),
                "owner": obj.get("owner"),
                "color": obj.get("color"),
                "public": obj.get("public"),
                "domain_guid": obj.get("domain_guid"),
                "runner_mode": obj.get("runner_mode"),
                "cluster_guid": obj.get("cluster_guid"),
                "cluster": Cluster.from_dict(obj["cluster"])
                if obj.get("cluster") is not None
                else None,
                "modified": obj.get("modified"),
                "created": obj.get("created"),
            }
        )
        return _obj
