# coding: utf-8

"""


No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing_extensions import Self

from gretel_client.rest_v1.models.serverless_tenant_cloud_provider_info import (
    ServerlessTenantCloudProviderInfo,
)
from gretel_client.rest_v1.models.serverless_tenant_config import ServerlessTenantConfig
from gretel_client.rest_v1.models.serverless_tenant_provisioning_state import (
    ServerlessTenantProvisioningState,
)


class ServerlessTenant(BaseModel):
    """
    Next Tag: 9
    """  # noqa: E501

    guid: StrictStr
    name: StrictStr
    domain_guid: StrictStr
    created_at: datetime
    cloud_provider: ServerlessTenantCloudProviderInfo
    config: ServerlessTenantConfig
    cluster_guid: Optional[StrictStr] = Field(
        default=None,
        description="The GUID of the cluster that the tenant is associated with. Deprecated: No longer used.",
    )
    provisioning_state: Optional[ServerlessTenantProvisioningState] = None
    __properties: ClassVar[List[str]] = [
        "guid",
        "name",
        "domain_guid",
        "created_at",
        "cloud_provider",
        "config",
        "cluster_guid",
        "provisioning_state",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ServerlessTenant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cloud_provider
        if self.cloud_provider:
            _dict["cloud_provider"] = self.cloud_provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict["config"] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of provisioning_state
        if self.provisioning_state:
            _dict["provisioning_state"] = self.provisioning_state.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ServerlessTenant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "guid": obj.get("guid"),
                "name": obj.get("name"),
                "domain_guid": obj.get("domain_guid"),
                "created_at": obj.get("created_at"),
                "cloud_provider": ServerlessTenantCloudProviderInfo.from_dict(
                    obj["cloud_provider"]
                )
                if obj.get("cloud_provider") is not None
                else None,
                "config": ServerlessTenantConfig.from_dict(obj["config"])
                if obj.get("config") is not None
                else None,
                "cluster_guid": obj.get("cluster_guid"),
                "provisioning_state": ServerlessTenantProvisioningState.from_dict(
                    obj["provisioning_state"]
                )
                if obj.get("provisioning_state") is not None
                else None,
            }
        )
        return _obj
