# coding: utf-8

"""


No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing_extensions import Self

from gretel_client.rest_v1.models.action_summary import ActionSummary
from gretel_client.rest_v1.models.project import Project
from gretel_client.rest_v1.models.status_details import StatusDetails
from gretel_client.rest_v1.models.user_profile import UserProfile
from gretel_client.rest_v1.models.workflow_run_billing_summary import (
    WorkflowRunBillingSummary,
)
from gretel_client.rest_v1.models.workflow_run_cancellation_request import (
    WorkflowRunCancellationRequest,
)
from gretel_client.rest_v1.models.workflow_run_report import WorkflowRunReport


class WorkflowRun(BaseModel):
    """
    WorkflowRun
    """  # noqa: E501

    id: StrictStr = Field(description="The unique ID of the workflow run.")
    workflow_id: StrictStr = Field(
        description="The ID of the workflow that this run belongs to."
    )
    name: Optional[StrictStr] = Field(
        default=None, description="The name of the workflow run."
    )
    project_id: StrictStr = Field(
        description="The project ID that this workflow run belongs to. This will be the same as the project ID of the workflow."
    )
    project: Optional[Project] = Field(
        default=None,
        description="The project that this workflow run belongs to. Provided when the `expand=project` query param is present.",
    )
    cluster_guid: Optional[StrictStr] = Field(
        default=None,
        description="The GUID of the cluster where the workflow run is executed.",
    )
    config: Optional[Dict[str, Any]] = Field(
        default=None, description="The config of the workflow run."
    )
    config_text: Optional[StrictStr] = Field(
        default=None, description="The config of the workflow run as a YAML string."
    )
    runner_mode: StrictStr = Field(
        description="The runner mode of the workflow run. Can be `cloud` or `hybrid`."
    )
    status: StrictStr = Field(description="The status of the workflow run.")
    status_details: Optional[StatusDetails] = Field(
        default=None,
        description="Additional details about the status of the workflow run.",
    )
    created_by: StrictStr = Field(
        description="The user ID that created this workflow run."
    )
    created_at: datetime = Field(
        description="A timestamp indicating when this workflow run was created."
    )
    updated_at: Optional[datetime] = Field(
        default=None,
        description="A timestamp indicating when this workflow run was last updated.",
    )
    pending_at: Optional[datetime] = Field(
        default=None,
        description="A timestamp indicating when this workflow run entered the pending state.",
    )
    active_at: Optional[datetime] = Field(
        default=None,
        description="A timestamp indicating when this workflow run entered the active state.",
    )
    error_at: Optional[datetime] = Field(
        default=None,
        description="A timestamp indicating when an error occurred in this workflow run.",
    )
    lost_at: Optional[datetime] = Field(
        default=None,
        description="A timestamp indicating when this workflow run was lost.",
    )
    cancelled_at: Optional[datetime] = Field(
        default=None,
        description="A timestamp indicating when this workflow run was cancelled.",
    )
    lease_expires_at: Optional[datetime] = Field(
        default=None,
        description="A timestamp indicating when the lease for this workflow run expires.",
    )
    cancellation_request: Optional[WorkflowRunCancellationRequest] = Field(
        default=None, description="The cancellation request for this workflow run."
    )
    created_by_profile: Optional[UserProfile] = Field(
        default=None,
        description="The user profile of the user that created this workflow run. Provided when the `expand=created_by` query param is present.",
    )
    total_compute_time_sconds: Optional[StrictInt] = Field(
        default=None,
        description="The total compute time in seconds for this workflow run.",
    )
    actions: Optional[List[ActionSummary]] = Field(
        default=None,
        description="An ordered summary of the actions in this workflow run. Provided when the `expand=actions` query param is present.",
    )
    billing_summary: Optional[WorkflowRunBillingSummary] = None
    report: Optional[WorkflowRunReport] = Field(
        default=None, description="Report data produced by the run"
    )
    __properties: ClassVar[List[str]] = [
        "id",
        "workflow_id",
        "name",
        "project_id",
        "project",
        "cluster_guid",
        "config",
        "config_text",
        "runner_mode",
        "status",
        "status_details",
        "created_by",
        "created_at",
        "updated_at",
        "pending_at",
        "active_at",
        "error_at",
        "lost_at",
        "cancelled_at",
        "lease_expires_at",
        "cancellation_request",
        "created_by_profile",
        "total_compute_time_sconds",
        "actions",
        "billing_summary",
        "report",
    ]

    @field_validator("runner_mode")
    def runner_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(
            [
                "RUNNER_MODE_UNSET",
                "RUNNER_MODE_CLOUD",
                "RUNNER_MODE_HYBRID",
                "RUNNER_MODE_INVALID",
            ]
        ):
            raise ValueError(
                "must be one of enum values ('RUNNER_MODE_UNSET', 'RUNNER_MODE_CLOUD', 'RUNNER_MODE_HYBRID', 'RUNNER_MODE_INVALID')"
            )
        return value

    @field_validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(
            [
                "RUN_STATUS_UNKNOWN",
                "RUN_STATUS_CREATED",
                "RUN_STATUS_PENDING",
                "RUN_STATUS_ACTIVE",
                "RUN_STATUS_ERROR",
                "RUN_STATUS_LOST",
                "RUN_STATUS_COMPLETED",
                "RUN_STATUS_CANCELLING",
                "RUN_STATUS_CANCELLED",
                "RUN_STATUS_SKIPPED",
            ]
        ):
            raise ValueError(
                "must be one of enum values ('RUN_STATUS_UNKNOWN', 'RUN_STATUS_CREATED', 'RUN_STATUS_PENDING', 'RUN_STATUS_ACTIVE', 'RUN_STATUS_ERROR', 'RUN_STATUS_LOST', 'RUN_STATUS_COMPLETED', 'RUN_STATUS_CANCELLING', 'RUN_STATUS_CANCELLED', 'RUN_STATUS_SKIPPED')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict["project"] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status_details
        if self.status_details:
            _dict["status_details"] = self.status_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cancellation_request
        if self.cancellation_request:
            _dict["cancellation_request"] = self.cancellation_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by_profile
        if self.created_by_profile:
            _dict["created_by_profile"] = self.created_by_profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in actions (list)
        _items = []
        if self.actions:
            for _item in self.actions:
                if _item:
                    _items.append(_item.to_dict())
            _dict["actions"] = _items
        # override the default output from pydantic by calling `to_dict()` of billing_summary
        if self.billing_summary:
            _dict["billing_summary"] = self.billing_summary.to_dict()
        # override the default output from pydantic by calling `to_dict()` of report
        if self.report:
            _dict["report"] = self.report.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "workflow_id": obj.get("workflow_id"),
                "name": obj.get("name"),
                "project_id": obj.get("project_id"),
                "project": Project.from_dict(obj["project"])
                if obj.get("project") is not None
                else None,
                "cluster_guid": obj.get("cluster_guid"),
                "config": obj.get("config"),
                "config_text": obj.get("config_text"),
                "runner_mode": obj.get("runner_mode"),
                "status": obj.get("status"),
                "status_details": StatusDetails.from_dict(obj["status_details"])
                if obj.get("status_details") is not None
                else None,
                "created_by": obj.get("created_by"),
                "created_at": obj.get("created_at"),
                "updated_at": obj.get("updated_at"),
                "pending_at": obj.get("pending_at"),
                "active_at": obj.get("active_at"),
                "error_at": obj.get("error_at"),
                "lost_at": obj.get("lost_at"),
                "cancelled_at": obj.get("cancelled_at"),
                "lease_expires_at": obj.get("lease_expires_at"),
                "cancellation_request": WorkflowRunCancellationRequest.from_dict(
                    obj["cancellation_request"]
                )
                if obj.get("cancellation_request") is not None
                else None,
                "created_by_profile": UserProfile.from_dict(obj["created_by_profile"])
                if obj.get("created_by_profile") is not None
                else None,
                "total_compute_time_sconds": obj.get("total_compute_time_sconds"),
                "actions": [ActionSummary.from_dict(_item) for _item in obj["actions"]]
                if obj.get("actions") is not None
                else None,
                "billing_summary": WorkflowRunBillingSummary.from_dict(
                    obj["billing_summary"]
                )
                if obj.get("billing_summary") is not None
                else None,
                "report": WorkflowRunReport.from_dict(obj["report"])
                if obj.get("report") is not None
                else None,
            }
        )
        return _obj
