# coding: utf-8

"""


No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing_extensions import Self

from gretel_client.rest_v1.models.project import Project
from gretel_client.rest_v1.models.user_profile import UserProfile


class WorkflowTask(BaseModel):
    """
    Next Tag: 26
    """  # noqa: E501

    id: StrictStr = Field(description="The unique ID of the workflow task.")
    workflow_run_id: StrictStr = Field(
        description="The ID of the workflow run that this task belongs to."
    )
    project_id: StrictStr = Field(
        description="The project ID that this workflow task belongs to."
    )
    project: Optional[Project] = Field(
        default=None,
        description="The project that this workflow task belongs to. Provided when the `expand=project` query param is present.",
    )
    log_location: StrictStr = Field(
        description="The location of the log for this workflow task."
    )
    status: StrictStr = Field(description="The status of the workflow task.")
    action_name: StrictStr = Field(
        description="The user supplied name of the workflow action that produced this task. The name can be mapped back to the original workflow config."
    )
    action_type: StrictStr = Field(
        description="The type of workflow action running the task. Eg `s3_source` or `gretel_model`."
    )
    error_msg: Optional[StrictStr] = Field(
        default=None,
        description="If the task is in an error state, this field will get populated with an error message suitable for displaying in the console. These error messages are meant to span a single line, and will be human readable.",
    )
    error_code: Optional[StrictInt] = Field(
        default=None,
        description="The code associated with an error message. These codes can be used to group like errors together.",
    )
    stack_trace: Optional[StrictStr] = Field(
        default=None,
        description="A more detailed stack trace that can be used for root cause analysis. This stack trace generally shouldn't be shown in the UI and will span many lines.",
    )
    created_by: StrictStr = Field(description="The user ID that created this workflow.")
    created_by_profile: Optional[UserProfile] = Field(
        default=None,
        description="The user profile of the user that created this workflow. Provided when the `expand=created_by` query param is present.",
    )
    created_at: datetime = Field(
        description="A timestamp indicating when this workflow was created."
    )
    updated_at: Optional[datetime] = Field(
        default=None,
        description="A timestamp indicating when this workflow was last updated.",
    )
    pending_at: Optional[datetime] = Field(
        default=None,
        description="A timestamp indicating when this workflow entered the pending state.",
    )
    active_at: Optional[datetime] = Field(
        default=None,
        description="A timestamp indicating when this workflow entered the active state.",
    )
    error_at: Optional[datetime] = Field(
        default=None,
        description="A timestamp indicating when an error occurred in this workflow.",
    )
    lost_at: Optional[datetime] = Field(
        default=None, description="A timestamp indicating when this workflow was lost."
    )
    completed_at: Optional[datetime] = Field(
        default=None,
        description="A timestamp indicating when this workflow was completed.",
    )
    cancelled_at: Optional[datetime] = Field(
        default=None,
        description="A timestamp indicating when this workflow was cancelled.",
    )
    total_compute_time_sconds: Optional[StrictInt] = Field(
        default=None, description="The total compute time in seconds for this workflow."
    )
    execution_summary: Optional[Dict[str, Any]] = Field(
        default=None, description="Metadata provided by the task as an output"
    )
    __properties: ClassVar[List[str]] = [
        "id",
        "workflow_run_id",
        "project_id",
        "project",
        "log_location",
        "status",
        "action_name",
        "action_type",
        "error_msg",
        "error_code",
        "stack_trace",
        "created_by",
        "created_by_profile",
        "created_at",
        "updated_at",
        "pending_at",
        "active_at",
        "error_at",
        "lost_at",
        "completed_at",
        "cancelled_at",
        "total_compute_time_sconds",
        "execution_summary",
    ]

    @field_validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(
            [
                "RUN_STATUS_UNKNOWN",
                "RUN_STATUS_CREATED",
                "RUN_STATUS_PENDING",
                "RUN_STATUS_ACTIVE",
                "RUN_STATUS_ERROR",
                "RUN_STATUS_LOST",
                "RUN_STATUS_COMPLETED",
                "RUN_STATUS_CANCELLING",
                "RUN_STATUS_CANCELLED",
                "RUN_STATUS_SKIPPED",
            ]
        ):
            raise ValueError(
                "must be one of enum values ('RUN_STATUS_UNKNOWN', 'RUN_STATUS_CREATED', 'RUN_STATUS_PENDING', 'RUN_STATUS_ACTIVE', 'RUN_STATUS_ERROR', 'RUN_STATUS_LOST', 'RUN_STATUS_COMPLETED', 'RUN_STATUS_CANCELLING', 'RUN_STATUS_CANCELLED', 'RUN_STATUS_SKIPPED')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowTask from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict["project"] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by_profile
        if self.created_by_profile:
            _dict["created_by_profile"] = self.created_by_profile.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowTask from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "workflow_run_id": obj.get("workflow_run_id"),
                "project_id": obj.get("project_id"),
                "project": Project.from_dict(obj["project"])
                if obj.get("project") is not None
                else None,
                "log_location": obj.get("log_location"),
                "status": obj.get("status"),
                "action_name": obj.get("action_name"),
                "action_type": obj.get("action_type"),
                "error_msg": obj.get("error_msg"),
                "error_code": obj.get("error_code"),
                "stack_trace": obj.get("stack_trace"),
                "created_by": obj.get("created_by"),
                "created_by_profile": UserProfile.from_dict(obj["created_by_profile"])
                if obj.get("created_by_profile") is not None
                else None,
                "created_at": obj.get("created_at"),
                "updated_at": obj.get("updated_at"),
                "pending_at": obj.get("pending_at"),
                "active_at": obj.get("active_at"),
                "error_at": obj.get("error_at"),
                "lost_at": obj.get("lost_at"),
                "completed_at": obj.get("completed_at"),
                "cancelled_at": obj.get("cancelled_at"),
                "total_compute_time_sconds": obj.get("total_compute_time_sconds"),
                "execution_summary": obj.get("execution_summary"),
            }
        )
        return _obj
