"""
Extended Matrix models for GraphML stratigraphic graphs

This model stores GraphML files generated by the Harris Creator.
"""

from sqlalchemy import Column, Integer, String, Text, DateTime, ForeignKey
from sqlalchemy.orm import relationship
from datetime import datetime
from .base import BaseModel


class ExtendedMatrix(BaseModel):
    """
    Extended Matrix GraphML storage

    Stores GraphML stratigraphic graphs generated by the Harris Creator
    for use with the 3D Builder and MCP server.
    """
    __tablename__ = 'extended_matrix_table'

    id = Column(Integer, primary_key=True, autoincrement=True)
    sito = Column(String(350), ForeignKey('site_table.sito', ondelete='CASCADE'), nullable=False)
    area = Column(String(20))

    # GraphML file data
    graphml_data = Column(Text, nullable=False)  # The GraphML XML content
    filename = Column(String(500))

    # Metadata
    node_count = Column(Integer)  # Number of nodes (US)
    edge_count = Column(Integer)  # Number of edges (relationships)
    description = Column(Text)

    # Timestamps
    created_at = Column(DateTime, default=datetime.utcnow)
    updated_at = Column(DateTime, default=datetime.utcnow, onupdate=datetime.utcnow)
    created_by = Column(String(100))

    # Relationships
    site_ref = relationship("Site", foreign_keys=[sito])

    def __repr__(self):
        return f"<ExtendedMatrix(id={self.id}, sito='{self.sito}', nodes={self.node_count})>"
