import param


class BinaryParams(param.Parameterized):
    # Image size parameters
    height = param.Integer(default=10, bounds=(1, 20), doc="Height in degrees")
    width = param.Integer(default=10, bounds=(1, 20), doc="Width in degrees")
    ppd = param.Integer(default=20, bounds=(1, 40), doc="Pixels per degree")

    intensity_min = param.Number(default=0.0, bounds=(0, 1), step=0.01, doc="")
    intensity_max = param.Number(default=1.0, bounds=(0, 1), step=0.01, doc="")

    def get_stimulus_params(self):
        return {
            "visual_size": (self.height, self.width),
            "ppd": self.ppd,
            "intensity_range": (self.intensity_min, self.intensity_max),
        }


__all__ = ["BinaryParams"]
