# Using Material Theme with Catppuccin Colors

**Recommended Approach**: Use Material for MkDocs theme with custom Catppuccin CSS instead of the mkdocs-catppuccin theme.

## Why Material Theme + Catppuccin CSS?

The `mkdocs-catppuccin` theme (v1.0.0) has known bugs with CSS loading. Instead, we recommend using the well-maintained Material for MkDocs theme with custom Catppuccin color schemes.

### Advantages

✅ **Stable & Feature-Rich**: Material theme is actively maintained with extensive features
✅ **All Icons & Components**: Full access to Material Design icons and UI components
✅ **Better Layout**: Professional navigation, search, and responsive design
✅ **No CSS Bugs**: Reliable CSS loading and browser compatibility
✅ **Beautiful Catppuccin Colors**: All four palettes available (Mocha, Macchiato, Frappe, Latte)
✅ **Easy Customization**: Work only with colors, not entire theme structure

## Quick Start

### 1. Install Dependencies

```bash
pip install mkdocs-material
```

Optional plugins for enhanced features:
```bash
pip install mkdocs-minify-plugin
```

### 2. Project Structure

Create this directory structure in your MkDocs project:

```
your-project/
├── docs/
│   ├── index.md
│   ├── stylesheets/
│   │   └── material-catppuccin-mocha.css  # Choose your palette
│   └── ...
└── mkdocs.yml
```

### 3. Copy CSS Files

Copy the appropriate Catppuccin CSS file from the `examples/` directory:

- **Mocha (Darkest)**: `material-catppuccin-mocha.css` - Deep, rich dark theme
- **Macchiato (Medium Dark)**: `material-catppuccin-macchiato.css` - Balanced dark theme
- **Frappe (Dark)**: `material-catppuccin-frappe.css` - Coffee-inspired dark theme
- **Latte (Light)**: `material-catppuccin-latte.css` - Clean light theme

Copy your chosen file to `docs/stylesheets/` in your project.

### 4. Configure mkdocs.yml

Create or update your `mkdocs.yml`:

```yaml
site_name: My Documentation

theme:
  name: material
  palette:
    scheme: slate  # Use 'slate' for dark themes (Mocha, Macchiato, Frappe)
                   # Use 'default' for light theme (Latte)

  features:
    - navigation.instant
    - navigation.tracking
    - navigation.tabs
    - navigation.sections
    - navigation.top
    - search.suggest
    - search.highlight
    - content.code.copy

extra_css:
  - stylesheets/material-catppuccin-mocha.css  # Or your chosen palette

nav:
  - Home: index.md
  - Getting Started: getting-started.md

plugins:
  - search
```

### 5. Run MkDocs

```bash
mkdocs serve
```

Your site will be available at `http://127.0.0.1:8000` with beautiful Catppuccin colors!

## Available Palettes

### 🌑 Mocha (Darkest)
Perfect for those who prefer the deepest, darkest theme.

```yaml
theme:
  palette:
    scheme: slate
extra_css:
  - stylesheets/material-catppuccin-mocha.css
```

### 🌆 Macchiato (Medium Dark)
A balanced dark theme that's easy on the eyes.

```yaml
theme:
  palette:
    scheme: slate
extra_css:
  - stylesheets/material-catppuccin-macchiato.css
```

### ☕ Frappe (Dark)
Coffee-inspired dark variant with warm undertones.

```yaml
theme:
  palette:
    scheme: slate
extra_css:
  - stylesheets/material-catppuccin-frappe.css
```

### ☀️ Latte (Light)
Clean and professional light theme for bright environments.

```yaml
theme:
  palette:
    scheme: default  # Note: use 'default' for Latte
extra_css:
  - stylesheets/material-catppuccin-latte.css
```

## Full Example Configuration

See `examples/mkdocs.yml` for a complete configuration with all recommended features including:

- Navigation configuration
- Search functionality
- Code highlighting
- Markdown extensions
- Social links
- And more!

## Switching Between Palettes

You can let users switch between palettes by configuring multiple color schemes:

```yaml
theme:
  name: material
  palette:
    # Light mode
    - media: "(prefers-color-scheme: light)"
      scheme: default
      toggle:
        icon: material/brightness-7
        name: Switch to dark mode

    # Dark mode
    - media: "(prefers-color-scheme: dark)"
      scheme: slate
      toggle:
        icon: material/brightness-4
        name: Switch to light mode

extra_css:
  - stylesheets/material-catppuccin-latte.css   # For light mode
  - stylesheets/material-catppuccin-mocha.css   # For dark mode
```

## Customization

### Using Catppuccin Color Variables

All CSS files expose Catppuccin colors as CSS variables. You can create your own custom CSS to override specific elements:

```css
/* docs/stylesheets/custom.css */

/* Use Catppuccin variables */
.my-custom-element {
  background-color: var(--ctp-blue);
  color: var(--ctp-text);
  border: 2px solid var(--ctp-mauve);
}

/* Available variables for all palettes: */
/* --ctp-rosewater, --ctp-flamingo, --ctp-pink, --ctp-mauve */
/* --ctp-red, --ctp-maroon, --ctp-peach, --ctp-yellow */
/* --ctp-green, --ctp-teal, --ctp-sky, --ctp-sapphire */
/* --ctp-blue, --ctp-lavender */
/* --ctp-text, --ctp-subtext1, --ctp-subtext0 */
/* --ctp-overlay2, --ctp-overlay1, --ctp-overlay0 */
/* --ctp-surface2, --ctp-surface1, --ctp-surface0 */
/* --ctp-base, --ctp-mantle, --ctp-crust */
```

Then add it to your config:

```yaml
extra_css:
  - stylesheets/material-catppuccin-mocha.css
  - stylesheets/custom.css
```

## Material Theme Features

With Material theme, you get access to many powerful features:

### Icons
```markdown
:material-heart: Material Design icons
:fontawesome-brands-github: Font Awesome icons
:octicons-mark-github-16: Octicons
```

### Admonitions
```markdown
!!! note "Note Title"
    This is a note with Catppuccin colors

!!! warning "Warning"
    This is a warning

!!! danger "Danger"
    This is a danger message

!!! tip "Pro Tip"
    This is a helpful tip
```

### Code Blocks with Highlighting
````markdown
```python hl_lines="2 3"
def hello_world():
    message = "Hello, Catppuccin!"  # Highlighted
    print(message)                   # Highlighted
```
````

### Tabs
```markdown
=== "Tab 1"
    Content for tab 1

=== "Tab 2"
    Content for tab 2
```

### Task Lists
```markdown
- [x] Set up Material theme
- [x] Add Catppuccin colors
- [x] Enjoy beautiful documentation
- [ ] Add more content
```

## Troubleshooting

### CSS Not Loading

1. Ensure the CSS file is in `docs/stylesheets/` directory
2. Check that the path in `extra_css` is correct
3. Clear browser cache and restart `mkdocs serve`

### Wrong Colors

- For dark themes (Mocha, Macchiato, Frappe): use `scheme: slate`
- For light theme (Latte): use `scheme: default`

### Icons Not Showing

Install the required packages:
```bash
pip install mkdocs-material[imaging]
```

## Resources

- [Material for MkDocs Documentation](https://squidfunk.github.io/mkdocs-material/)
- [Catppuccin Official Website](https://catppuccin.com/)
- [MkDocs Documentation](https://www.mkdocs.org/)

## Contributing

If you find issues with the CSS files or have suggestions for improvements, please open an issue or pull request on the repository.

---

**Note**: This approach replaces the need for the `mkdocs-catppuccin` theme package. You only need `mkdocs-material` and the custom CSS files provided.
