# Publishing to PyPI

This document describes how to publish the mkdocs-catppuccin package to PyPI.

## Setup (One-time configuration)

### 1. Configure Trusted Publishing on PyPI

Trusted publishing is the recommended way to publish to PyPI as it doesn't require API tokens.

1. Go to https://pypi.org/manage/account/publishing/ (or https://test.pypi.org/manage/account/publishing/ for TestPyPI)
2. Scroll to "Add a new pending publisher"
3. Fill in:
   - **PyPI Project Name**: `mkdocs-catppuccin`
   - **Owner**: `catppuccin` (or your GitHub organization/username)
   - **Repository name**: `mkdocs`
   - **Workflow name**: `publish.yml`
   - **Environment name**: `pypi` (or `testpypi` for TestPyPI)
4. Click "Add"

Repeat for TestPyPI if you want to test publishing first.

### 2. Configure GitHub Environment

1. Go to your repository settings → Environments
2. Create an environment named `pypi`
3. (Optional) Add protection rules:
   - Required reviewers
   - Deployment branches (e.g., only `main` branch)
4. Repeat for `testpypi` environment if needed

## Publishing Process

### Method 1: Automatic publishing via GitHub Releases (Recommended)

This is the easiest and most reliable method:

1. **Update the version number** in both files:
   - `setup.py`: Update the `version` field
   - `pyproject.toml`: Update the `version` field

2. **Commit and push** the version update:
   ```bash
   git add setup.py pyproject.toml
   git commit -m "Bump version to X.Y.Z"
   git push
   ```

3. **Create a new release** on GitHub:
   - Go to https://github.com/catppuccin/mkdocs/releases/new
   - Click "Choose a tag" and create a new tag (e.g., `v1.0.0`)
   - Fill in the release title and description
   - Click "Publish release"

4. **The GitHub Action will automatically**:
   - Build the package
   - Run checks
   - Publish to PyPI

5. **Verify the upload**:
   - Check https://pypi.org/project/mkdocs-catppuccin/
   - Test installation: `pip install mkdocs-catppuccin`

### Method 2: Manual workflow dispatch

You can manually trigger a publish to either PyPI or TestPyPI:

1. Go to https://github.com/catppuccin/mkdocs/actions/workflows/publish.yml
2. Click "Run workflow"
3. Select the target environment (`pypi` or `testpypi`)
4. Click "Run workflow"

### Method 3: Local publishing (Not recommended)

If you need to publish locally:

1. **Install build tools**:
   ```bash
   pip install build twine
   ```

2. **Build the distribution**:
   ```bash
   python -m build
   ```

3. **Check the distribution**:
   ```bash
   twine check dist/*
   ```

4. **Upload to TestPyPI** (for testing):
   ```bash
   twine upload --repository testpypi dist/*
   ```

5. **Upload to PyPI**:
   ```bash
   twine upload dist/*
   ```

   Note: You'll need API tokens or credentials for local publishing.

## Testing Before Publishing

### Test on TestPyPI first

1. Trigger the workflow manually (Method 2) with `testpypi` environment
2. Install from TestPyPI:
   ```bash
   pip install --index-url https://test.pypi.org/simple/ --extra-index-url https://pypi.org/simple mkdocs-catppuccin
   ```
3. Test the installation thoroughly
4. If everything works, proceed with publishing to PyPI

### Local testing

Before publishing, always test the package locally:

```bash
# Build the package
python -m build

# Install locally
pip install dist/mkdocs_catppuccin-*.whl

# Test with a sample MkDocs project
mkdocs new test-site
cd test-site
# Edit mkdocs.yml to use the theme
mkdocs serve
```

## Version Numbering

Follow [Semantic Versioning](https://semver.org/):

- **MAJOR** version (X.0.0): Incompatible API changes
- **MINOR** version (1.X.0): New features, backward compatible
- **PATCH** version (1.0.X): Bug fixes, backward compatible

## Troubleshooting

### "File already exists" error

PyPI doesn't allow re-uploading the same version. You need to:
1. Bump the version number
2. Create a new release

### Trusted publishing not working

Check:
1. The environment name in the workflow matches PyPI configuration
2. The repository and workflow names are correct on PyPI
3. The GitHub Actions workflow has `id-token: write` permission

### Build failures

Common issues:
- Missing files: Check `MANIFEST.in`
- Import errors: Ensure all dependencies are listed in `setup.py` and `pyproject.toml`
- Version conflicts: Make sure versions match in both `setup.py` and `pyproject.toml`

## Resources

- [PyPI Publishing Guide](https://packaging.python.org/en/latest/tutorials/packaging-projects/)
- [Trusted Publishing](https://docs.pypi.org/trusted-publishers/)
- [GitHub Actions PyPI Publish](https://github.com/marketplace/actions/pypi-publish)
