<h3 align="center">
  <img src="https://raw.githubusercontent.com/catppuccin/catppuccin/main/assets/logos/exports/1544x1544_circle.png" width="100" alt="Logo"/><br/>
  <img src="https://raw.githubusercontent.com/catppuccin/catppuccin/main/assets/misc/transparent.png" height="30" width="0px"/>
  Catppuccin for <a href="https://www.mkdocs.org/">MkDocs</a>
  <img src="https://raw.githubusercontent.com/catppuccin/catppuccin/main/assets/misc/transparent.png" height="30" width="0px"/>
</h3>

<p align="center">
  <a href="https://github.com/catppuccin/mkdocs/stargazers"><img src="https://img.shields.io/github/stars/catppuccin/mkdocs?colorA=363a4f&colorB=b7bdf8&style=for-the-badge"></a>
  <a href="https://github.com/catppuccin/mkdocs/issues"><img src="https://img.shields.io/github/issues/catppuccin/mkdocs?colorA=363a4f&colorB=f5a97f&style=for-the-badge"></a>
  <a href="https://github.com/catppuccin/mkdocs/contributors"><img src="https://img.shields.io/github/contributors/catppuccin/mkdocs?colorA=363a4f&colorB=a6da95&style=for-the-badge"></a>
  <a href="https://pypi.org/project/mkdocs-catppuccin/"><img src="https://img.shields.io/pypi/v/mkdocs-catppuccin?colorA=363a4f&colorB=fab387&style=for-the-badge"></a>
  <a href="https://pypi.org/project/mkdocs-catppuccin/"><img src="https://img.shields.io/pypi/dm/mkdocs-catppuccin?colorA=363a4f&colorB=89dceb&style=for-the-badge"></a>
</p>

<p align="center">
  <img src="https://raw.githubusercontent.com/catppuccin/catppuccin/main/assets/palette/macchiato.png" width="400" />
</p>

## About

Soothing pastel theme for [MkDocs](https://www.mkdocs.org/), featuring all four iconic Catppuccin flavors: Latte, Frappe, Macchiato, and Mocha.

**This theme extends [Material for MkDocs](https://squidfunk.github.io/mkdocs-material/)**, providing Catppuccin color schemes on top of Material's robust features, icons, and components.

## ✨ Features

- 🎨 All four Catppuccin flavors (Latte, Frappe, Macchiato, Mocha)
- 🎯 Built on Material for MkDocs - stable, feature-rich, and actively maintained
- 🔍 Full Material theme features: search, navigation, icons, and more
- 📱 Fully responsive design
- 🎭 Material Design icons and Font Awesome support
- 🌈 Beautiful syntax highlighting
- ⚡ No CSS loading bugs - reliable and fast
- 🎨 Easy customization using CSS variables

## Installation

### Install from PyPI

```bash
pip install mkdocs-catppuccin
```

This will automatically install `mkdocs-material` as a dependency.

### Install from source

For development or testing the latest changes:

```bash
git clone https://github.com/catppuccin/mkdocs.git
cd mkdocs
pip install -e .
```

## Usage

### Basic Configuration

Add the theme to your `mkdocs.yml`:

```yaml
site_name: My Documentation

theme:
  name: catppuccin
  palette: mocha  # Options: latte, frappe, macchiato, mocha
```

That's it! Your site now uses Material for MkDocs with Catppuccin colors.

### Available Flavors

The theme comes with four beautiful flavors:

- **🌑 Mocha** (Darkest) - The deepest, richest dark theme
- **🌆 Macchiato** (Medium Dark) - Balanced dark theme, easy on the eyes
- **☕ Frappe** (Dark) - Coffee-inspired darker variant
- **☀️ Latte** (Light) - Perfect for bright environments

### Full Configuration Example

```yaml
site_name: My Awesome Documentation
site_description: A great documentation site
site_author: Your Name
site_url: https://example.com

theme:
  name: catppuccin
  palette: mocha  # Choose: latte, frappe, macchiato, or mocha

  # Material theme features (all available!)
  features:
    - navigation.instant       # Instant loading
    - navigation.tracking      # URL tracking
    - navigation.tabs          # Navigation tabs
    - navigation.sections      # Navigation sections
    - navigation.expand        # Expand navigation by default
    - navigation.top           # Back to top button
    - search.suggest           # Search suggestions
    - search.highlight         # Highlight search results
    - content.code.copy        # Copy button for code blocks
    - content.tabs.link        # Link content tabs

  # Optional: custom favicon and logo
  # favicon: assets/favicon.png
  # logo: assets/logo.png

nav:
  - Home: index.md
  - Getting Started: getting-started.md
  - API Reference: api.md

plugins:
  - search

markdown_extensions:
  - admonition
  - pymdownx.highlight:
      anchor_linenums: true
  - pymdownx.inlinehilite
  - pymdownx.snippets
  - pymdownx.superfences
  - pymdownx.tabbed:
      alternate_style: true
  - toc:
      permalink: true

extra:
  social:
    - icon: fontawesome/brands/github
      link: https://github.com/yourusername
    - icon: fontawesome/brands/twitter
      link: https://twitter.com/yourusername

copyright: Copyright &copy; 2024 Your Name
```

## 🎨 Customization

### Using CSS Variables

The theme exposes all Catppuccin colors as CSS variables. You can use them in your custom CSS:

```yaml
# mkdocs.yml
extra_css:
  - stylesheets/custom.css
```

```css
/* docs/stylesheets/custom.css */
.custom-element {
  background-color: var(--ctp-blue);
  color: var(--ctp-text);
  border: 1px solid var(--ctp-surface0);
}
```

### Available Color Variables

All Catppuccin colors are available:

- **Accent colors**: `--ctp-rosewater`, `--ctp-flamingo`, `--ctp-pink`, `--ctp-mauve`
- **Primary colors**: `--ctp-red`, `--ctp-maroon`, `--ctp-peach`, `--ctp-yellow`
- **Success/Info colors**: `--ctp-green`, `--ctp-teal`, `--ctp-sky`, `--ctp-sapphire`
- **Link colors**: `--ctp-blue`, `--ctp-lavender`
- **Text colors**: `--ctp-text`, `--ctp-subtext1`, `--ctp-subtext0`
- **Overlay colors**: `--ctp-overlay2`, `--ctp-overlay1`, `--ctp-overlay0`
- **Surface colors**: `--ctp-surface2`, `--ctp-surface1`, `--ctp-surface0`
- **Background colors**: `--ctp-base`, `--ctp-mantle`, `--ctp-crust`

### Switching Between Palettes

You can let users switch between light and dark palettes:

```yaml
theme:
  name: catppuccin
  palette:
    # Light mode
    - media: "(prefers-color-scheme: light)"
      scheme: default
      toggle:
        icon: material/brightness-7
        name: Switch to dark mode

    # Dark mode
    - media: "(prefers-color-scheme: dark)"
      scheme: slate
      toggle:
        icon: material/brightness-4
        name: Switch to light mode
```

Note: When using palette toggle, you may need to add custom CSS for both light and dark schemes. See [MATERIAL_THEME_GUIDE.md](MATERIAL_THEME_GUIDE.md) for details.

## 📚 Material Theme Features

Since this theme extends Material for MkDocs, you get access to all Material features:

### Icons

```markdown
:material-heart: Material Design icons
:fontawesome-brands-github: Font Awesome icons
:octicons-mark-github-16: Octicons
```

### Admonitions

```markdown
!!! note "Note Title"
    This is a note with Catppuccin colors

!!! warning "Warning"
    This is a warning

!!! danger "Danger"
    This is a danger message

!!! tip "Pro Tip"
    This is a helpful tip
```

### Code Blocks with Highlighting

````markdown
```python hl_lines="2 3"
def hello_world():
    message = "Hello, Catppuccin!"  # Highlighted
    print(message)                   # Highlighted
```
````

### Content Tabs

```markdown
=== "Python"
    ```python
    print("Hello, World!")
    ```

=== "JavaScript"
    ```javascript
    console.log("Hello, World!");
    ```
```

### Task Lists

```markdown
- [x] Set up Catppuccin theme
- [x] Add content
- [x] Enjoy beautiful documentation
- [ ] Add more features
```

## 📖 Documentation

For more detailed information about using Material theme with Catppuccin colors, see:

- [MATERIAL_THEME_GUIDE.md](MATERIAL_THEME_GUIDE.md) - Detailed guide for advanced usage
- [examples/](examples/) - Example configurations and CSS files
- [Material for MkDocs Documentation](https://squidfunk.github.io/mkdocs-material/) - Full Material theme documentation

## 🛠️ Development

To work on the theme locally:

```bash
# Clone the repository
git clone https://github.com/catppuccin/mkdocs.git
cd mkdocs

# Install in editable mode
pip install -e .

# Create a test site
mkdocs new test-site
cd test-site

# Edit mkdocs.yml to use the theme
# Then serve the site
mkdocs serve
```

## 🚀 Migration from v1.0.0

If you're upgrading from v1.0.0 (the standalone theme with CSS bugs), the new version is much simpler:

**Old configuration:**
```yaml
theme:
  name: catppuccin
  palette: mocha
  # Limited features, CSS bugs
```

**New configuration (Material-based):**
```yaml
theme:
  name: catppuccin
  palette: mocha
  # All Material features now available!
  features:
    - navigation.instant
    - search.suggest
    # ... many more features
```

The API is the same, but now you get:
- ✅ No CSS loading bugs
- ✅ All Material theme features
- ✅ Better icons and navigation
- ✅ More reliable and maintained codebase

## 🤝 Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

### Publishing to PyPI

For maintainers who want to publish a new version to PyPI, see the [PUBLISHING.md](PUBLISHING.md) guide for detailed instructions.

## 📜 License

MIT License - see [LICENSE](LICENSE) for details

## 🙏 Acknowledgments

- [Catppuccin](https://github.com/catppuccin/catppuccin) - The amazing color palette
- [Material for MkDocs](https://squidfunk.github.io/mkdocs-material/) - The excellent theme we build upon
- [MkDocs](https://www.mkdocs.org/) - The fast, simple static site generator

---

<p align="center">
  <img src="https://raw.githubusercontent.com/catppuccin/catppuccin/main/assets/footers/gray0_ctp_on_line.svg?sanitize=true" />
</p>

<p align="center">
  Copyright &copy; 2024 <a href="https://github.com/catppuccin">Catppuccin Org</a>
</p>

<p align="center">
  <a href="https://github.com/catppuccin/catppuccin/blob/main/LICENSE"><img src="https://img.shields.io/static/v1.svg?style=for-the-badge&label=License&message=MIT&logoColor=d9e0ee&colorA=363a4f&colorB=b7bdf8"/></a>
</p>
