from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="mkdocs-catppuccin",
    version="1.0.0",
    author="Catppuccin",
    author_email="",
    description="Soothing pastel theme for MkDocs",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/catppuccin/mkdocs",
    packages=find_packages(),
    include_package_data=True,
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "Topic :: Documentation",
        "Topic :: Software Development :: Documentation",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
    ],
    python_requires=">=3.7",
    install_requires=[
        "mkdocs>=1.0",
        "mkdocs-material>=9.0",
    ],
    entry_points={
        "mkdocs.themes": [
            "catppuccin = catppuccin_mkdocs",
        ]
    },
    keywords="mkdocs theme catppuccin pastel documentation",
)
