# Custom ANN types

Since arbitrary information may be encoded in the annotation field, `vembrane` has custom parsers for most of them.
The tables below give an overview of annotations that are recognized by vembrane; any unrecognized annotation is left unchanged (i.e. is of type `str`).
The descriptions are mostly taken from the `snpEff` and `vep` website/documentation, if available.

## vep

Annotations with custom types:

| Name in vep `ANN`    | Type                                                   | Description                                                                                                                                                   | Example expression                                                          |
|----------------------|--------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------|
| `Consequence`        | `Consequences` / `list[Term]`                          | Consequence types of this variant                                                                                                                             | `'ANN["Consequence"].any_is_a("intron_variant")'`                           |
| `cDNA_position`      | `PosRange` with properties `start`, `end` and `length` |                                                                                                                                                               | `'ANN["cDNA_position"].start < 42'`                                         |
| `CDS_position`       | `PosRange` with properties `start`, `end` and `length` |                                                                                                                                                               | `'ANN["CDS_position"].end > 42'`                                            |
| `Protein_position`   | `PosRange` with properties `start`, `end` and `length` |                                                                                                                                                               | `'ANN["Protein_position"].length == 42'`                                    |
| `STRAND`             | `int`                                                  | The DNA strand (1 or -1) on which the transcript/feature lies                                                                                                 |                                                                             |
| `FLAGS`              | `list[str]`                                            | Transcript quality flags: `cds_start_NF`: CDS 5' incomplete, `cds_end_NF`: CDS 3' incomplete                                                                  |                                                                             |
| `HGVS_OFFSET`        | `int`                                                  | Indicates by how many bases the HGVS notations for this variant have been shifted                                                                             |                                                                             |
| `SIFT`               | `Dict[str, float]`                                     | The SIFT prediction and/or score, with both given as prediction(score)                                                                                        | `'ANN["SIFT"]["tolerated"] > 0.05'`                                         |
| `PolyPhen`           | `Dict[str, float]`                                     | The PolyPhen prediction and/or score                                                                                                                          | `'ANN["PolyPhen"]["probably_damaging"] > 0.9'`                              |
| `MOTIF_POS`          | `int`                                                  | The relative position of the variation in the aligned TFBP                                                                                                    |                                                                             |
| `HIGH_INF_POS`       | `bool`                                                 | A flag indicating if the variant falls in a high information position of a transcription factor binding profile (TFBP)                                        |                                                                             |
| `MOTIF_SCORE_CHANGE` | `float`                                                | The difference in motif score of the reference and variant sequences for the TFBP                                                                             |                                                                             |
| `CELL_TYPE`          | `list[str]`                                            | List of cell types and classifications for regulatory feature                                                                                                 |                                                                             |
| `CANONICAL`          | `bool`                                                 | A flag indicating if the transcript is denoted as the canonical transcript for this gene                                                                      |                                                                             |
| `INTRON`             | `RangeTotal` with properties `range` and `total`       | The known range of the intron indices (out of total number of introns)                                                                                        | `'ANN["INTRON"].range.start == 2'`                                          |
| `EXON`               | `RangeTotal` with properties `range` and `total`       | The known range of the exon indices (out of the total number of exons)                                                                                        | `'ANN["EXON"].total >= 2'`                                                  |
| `DOMAINS`            | `list[dict[str, Any]]`                                 | The source and identifer of any overlapping protein domains                                                                                                   | `'ANN["DOMAINS"] is not NA and ("PTHR16515" in ANN["DOMAINS"]["PANTHER"])'` |
| `DISTANCE`           | `int`                                                  | Shortest distance from variant to transcript                                                                                                                  |                                                                             |
| `AF`                 | `float`                                                | Frequency of existing variant in 1000 Genomes                                                                                                                 |                                                                             |
| `AFR_AF`             | `float`                                                | Frequency of existing variant in 1000 Genomes combined African population                                                                                     |                                                                             |
| `AMR_AF`             | `float`                                                | Frequency of existing variant in 1000 Genomes combined American population                                                                                    |                                                                             |
| `ASN_AF`             | `float`                                                | Frequency of existing variant in 1000 Genomes combined Asian population                                                                                       |                                                                             |
| `EUR_AF`             | `float`                                                | Frequency of existing variant in 1000 Genomes combined European population                                                                                    |                                                                             |
| `EAS_AF`             | `float`                                                | Frequency of existing variant in 1000 Genomes combined East Asian population                                                                                  |                                                                             |
| `SAS_AF`             | `float`                                                | Frequency of existing variant in 1000 Genomes combined South Asian population                                                                                 |                                                                             |
| `AA_AF`              | `float`                                                | Frequency of existing variant in NHLBI-ESP African American population                                                                                        |                                                                             |
| `EA_AF`              | `float`                                                | Frequency of existing variant in NHLBI-ESP European American population                                                                                       |                                                                             |
| `gnomAD_AF`          | `float`                                                | Frequency of existing variant in gnomAD exomes combined population                                                                                            |                                                                             |
| `gnomAD_AFR_AF`      | `float`                                                | Frequency of existing variant in gnomAD exomes African/American population                                                                                    |                                                                             |
| `gnomAD_AMR_AF`      | `float`                                                | Frequency of existing variant in gnomAD exomes American population                                                                                            |                                                                             |
| `gnomAD_ASJ_AF`      | `float`                                                | Frequency of existing variant in gnomAD exomes Ashkenazi Jewish population                                                                                    |                                                                             |
| `gnomAD_EAS_AF`      | `float`                                                | Frequency of existing variant in gnomAD exomes East Asian population                                                                                          |                                                                             |
| `gnomAD_FIN_AF`      | `float`                                                | Frequency of existing variant in gnomAD exomes Finnish population                                                                                             |                                                                             |
| `gnomAD_NFE_AF`      | `float`                                                | Frequency of existing variant in gnomAD exomes Non-Finnish European population                                                                                |                                                                             |
| `gnomAD_OTH_AF`      | `float`                                                | Frequency of existing variant in gnomAD exomes combined other combined populations                                                                            |                                                                             |
| `gnomAD_SAS_AF`      | `float`                                                | Frequency of existing variant in gnomAD exomes South Asian population                                                                                         |                                                                             |
| `MAX_AF`             | `float`                                                | Maximum observed allele frequency in 1000 Genomes, ESP and gnomAD                                                                                             |                                                                             |
| `MAX_AF_POPS`        | `list[str]`                                            | Populations in which maximum allele frequency was observed                                                                                                    |                                                                             |
| `CLIN_SIG`           | `list[str]`                                            | ClinVar clinical significance of the dbSNP variant                                                                                                            | `'"uncertain_significance" in ANN["CLIN_SIG"]'`                             |
| `PUBMED`             | `list[str]`                                            | Pubmed ID(s) of publications that cite existing variant                                                                                                       |                                                                             |
| `SOMATIC`            | `list[str]`                                            | Somatic status of existing variant(s); multiple values correspond to multiple values in the Existing_variation field                                          |                                                                             |
| `PHENO`              | `list[str]`                                            | Indicates if existing variant is associated with a phenotype, disease or trait; multiple values correspond to multiple values in the Existing_variation field |                                                                             |
| `GENE_PHENO`         | `list[str]`                                            | Indicates if overlapped gene is associated with a phenotype, disease or trait                                                                                 |                                                                             |
| `ALLELE_NUM`         | `int`                                                  | Allele number from input; 0 is reference, 1 is first alternate etc                                                                                            |                                                                             |
| `OverlapBP`          | `int`                                                  | Number of base pairs overlapping with the corresponding structural variation feature                                                                          |                                                                             |
| `OverlapPC`          | `float`                                                | Percentage of corresponding structural variation feature overlapped by the given input                                                                        |                                                                             |
| `Amino_acids`        | `list[str]`                                            | Reference and variant amino acids                                                                                                                             |                                                                             |
| `Codons`             | `list[str]`                                            | Reference and variant codon sequence                                                                                                                          |                                                                             |
| `Existing_variation` | `list[str]`                                            | Identifier(s) of co-located known variants                                                                                                                    |                                                                             |
| `LoFtool`            | `float`                                                | Provides a rank of genic intolerance and consequent susceptibility to disease based on the ratio of Loss-of-function (LoF) to synonymous mutations."          |                                                                             |
| `REVEL`              | `float`                                                | Estimate of the pathogenicity of missense variants.                                                                                                           |                                                                             |
| `ExACpLI`            | `float`                                                | Probabililty of a gene being loss-of-function intolerant (pLI).                                                                                               |                                                                             |


Annotations with type `str`:

| Name in vep `ANN`    | Description                                                                                                                                 | Example expression          |
|----------------------|---------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------|
| `Location`           | In standard coordinate format (chr:start or chr:start-end)                                                                                  |                             |
| `Allele`             | The variant allele used to calculate the consequence                                                                                        |                             |
| `Gene`               | Ensembl stable ID of affected gene                                                                                                          |                             |
| `Feature`            | Ensembl stable ID of feature                                                                                                                |                             |
| `Feature_type`       | Type of feature. Currently one of Transcript, RegulatoryFeature, MotifFeature.                                                              |                             |
| `HGVSc`              | [HGVS notation](https://hgvs-nomenclature.org/stable/background/simple/) for the variant relative to the coding sequence of the gene        |                             |
| `HGVSp`              | [HGVS notation](https://hgvs-nomenclature.org/stable/background/simple/) for the variant relative to the protein sequence                   |                             |
| `HGVSg`              | [HGVS notation](https://hgvs-nomenclature.org/stable/background/simple/) for the variant relative to the genomic sequence                   |                             |
| `REF_ALLELE`         | The reference allele                                                                                                                        |                             |
| `IMPACT`             | The impact modifier for the consequence type                                                                                                | `'"HIGH" in ANN["IMPACT"]'` |
| `SYMBOL`             | The gene symbol                                                                                                                             |                             |
| `VARIANT_CLASS`      | Sequence Ontology variant class                                                                                                             |                             |
| `SYMBOL_SOURCE`      | The source of the gene symbol                                                                                                               |                             |
| `ENSP`               | The Ensembl protein identifier of the affected transcript                                                                                   |                             |
| `SWISSPROT`          | Best match UniProtKB/Swiss-Prot accession of protein product                                                                                |                             |
| `TREMBL`             | Best match UniProtKB/TrEMBL accession of protein product                                                                                    |                             |
| `UNIPARC`            | Best match UniParc accession of protein product                                                                                             |                             |
| `MOTIF_NAME`         | The source and identifier of a transcription factor binding profile aligned at this position                                                |                             |
| `CCDS`               | The CCDS identifier for this transcript, where applicable                                                                                   |                             |
| `IND`                | Individual name                                                                                                                             |                             |
| `BIOTYPE`            | Biotype of transcript or regulatory feature                                                                                                 |                             |
| `APPRIS`             | Annotates alternatively spliced transcripts as primary or alternate based on a range of computational methods. NB: not available for GRCh37 |                             |
| `TSL`                | Transcript support level. NB: not available for GRCh37                                                                                      |                             |
| `GIVEN_REF`          | Reference allele from input                                                                                                                 |                             |
| `USED_REF`           | Reference allele as used to get consequences                                                                                                |                             |
| `AMBIGUITY`          | IUPAC allele ambiguity code                                                                                                                 |                             |
| `HGNC_ID`            |                                                                                                                                             |                             |
| `MANE`               | Matched Annotation from NCBI and EMBL-EBI (MANE).                                                                                           |                             |
| `MANE_SELECT`        | Matched Annotation from NCBI and EMBL-EBI (MANE) canonical transcript.                                                                      |                             |
| `MANE_PLUS_CLINICAL` | MANE transcripts beyond MANE_SELECT that are clinically relevant.                                                                           |                             |
| `GO`                 | Gene ontology (GO) terms.                                                                                                                   |                             |
| `miRNA`              | Determines where in the secondary structure of a miRNA a variant falls                                                                      |                             |


## snpEff
Annotations with custom types:

| Name in snpEff `ANN`       | Type                                                   | Description | Example expression                               |
|----------------------------|--------------------------------------------------------|-------------|--------------------------------------------------|
| `Annotation`               | `Consequences` / `list[Term]`                          |             | `'ANN["Annotation"].any_is_a("intron_variant")'` |
| `cDNA.pos / cDNA.length`   | `PosRange` with properties `start`, `end` and `length` |             | `'ANN["cDNA.pos / cDNA.length"].start < 42'`     |
| `CDS.pos / CDS.length`     | `PosRange` with properties `start`, `end` and `length` |             | `'ANN["CDS.pos / CDS.length"].end > 42'`         |
| `AA.pos / AA.length`       | `PosRange` with properties `start`, `end` and `length` |             | `'ANN["AA.pos / AA.length"].length == 42'`       |
| `ERRORS / WARNINGS / INFO` | `list[str]`                                            |             |                                                  |


Annotations with type `str`:

| Name in snpEff `ANN` | Description | Example expression |
|----------------------|-------------|--------------------|
| `Allele`             |             |                    |
| `Annotation_Impact`  |             |                    |
| `Gene_Name`          |             |                    |
| `Gene_ID`            |             |                    |
| `Feature_Type`       |             |                    |
| `Feature_ID`         |             |                    |
| `Transcript_BioType` |             |                    |
| `Rank`               |             |                    |
| `HGVS.c`             |             |                    |
| `HGVS.p`             |             |                    |
| `Distance`           |             |                    |
