<%!
def format_constant(const, indent=" "*8):
    """
    Format a constant definition.
    """
    if isinstance(const, tuple):
        type_name, var_name, value, comment = const
        if comment:
            return f"{indent}{type_name} {var_name}; // {comment}"
        return f"{indent}{type_name} {var_name};"
    return f"{indent}{const};"

def format_config(conf, indent=" "*8):
    """
    Format a config definition.
    """
    if isinstance(conf, tuple):
        type_name, var_name, default, comment = conf
        if default is not None:
            if isinstance(default, bool):
                default = "ture" if default else "false"
            if comment:
                return f"{indent}{type_name} {var_name}{{{default}}}; // {comment}"
            return f"{indent}{type_name} {var_name}{{{default}}};"
        else:
            if comment:
                return f"{indent}{type_name} {var_name}; // {comment}"
            return f"{indent}{type_name} {var_name};"
    return f"{indent}{conf};"
%>\
/* 
    Autogenerated using:
    - Template: '${template_path}'
    - Model definition: '${yaml_path}'
    Do not modify this autogenerated code. Instead modify template
    or model definition.
*/
#ifndef ${model_name.upper()}_HPP
#define ${model_name.upper()}_HPP
#include "cubnm/models/base.hpp"
% if external_declarations:

${external_declarations}
% endif

class ${model_name}Model : public BaseModel {
public:
    // Constants struct - must always be defined even if empty
    struct Constants {
% if constants:
% for const in constants:
${format_constant(const)}
% endfor
% endif
    };

    // Config struct - must always be defined even if empty
    struct Config {
% if config:
% for conf in config:
${format_config(conf)}
% endfor
% endif
    };

    using BaseModel::BaseModel;
    
    ~${model_name}Model() {
        if (cpu_initialized) {
            this->free_cpu();
            if (cpu_noise_initialized) {
                this->free_cpu_noise();
            }
        }
% if gpu_enabled:
        if (gpu_initialized) {
            this->free_gpu();
            if (gpu_noise_initialized) {
                this->free_gpu_noise();
            }
        }
% endif
    }

    // Static model properties
    static constexpr char* name = "${model_name}";
    static constexpr int n_state_vars = ${n_state_vars};
    static constexpr int n_intermediate_vars = ${n_intermediate_vars};
    static constexpr int n_noise = ${n_noise};
    static constexpr int n_global_params = ${n_global_params};
    static constexpr int n_regional_params = ${n_regional_params};
    static constexpr int conn_state_var_idx = ${conn_state_var_idx};
    static constexpr int bold_state_var_idx = ${bold_state_var_idx};
    static constexpr int n_ext_int = ${n_ext_int};
    static constexpr int n_ext_bool = ${n_ext_bool};
    static constexpr int n_ext_int_shared = ${n_ext_int_shared};
    static constexpr int n_ext_bool_shared = ${n_ext_bool_shared};
    static constexpr int n_global_out_int = ${n_global_out_int};
    static constexpr int n_global_out_bool = ${n_global_out_bool};
    static constexpr int n_global_out_double = ${n_global_out_double};
    static constexpr int n_regional_out_int = ${n_regional_out_int};
    static constexpr int n_regional_out_bool = ${n_regional_out_bool};
    static constexpr int n_regional_out_double = ${n_regional_out_double};
    static constexpr bool has_post_bw_step = ${str(has_post_bw_step).lower()};
    static constexpr bool has_post_integration = ${str(has_post_integration).lower()};
    static constexpr bool is_osc = ${str(is_osc).lower()};

    // Static members
    static Constants mc;
    Config conf;

    // Static initialization method
    static void init_constants(double dt = 0.1);
    % if config:
    void set_conf(std::map<std::string, std::string> config_map) override;
    % endif
    % if has_prep_params:
    void prep_params(double ** global_params, double ** regional_params, double * v_list,
            double ** SC, int * SC_indices, double * SC_dist,
            bool ** global_out_bool, int ** global_out_int) override final;
    % endif
% if gpu_enabled:
    // Device-callable methods (GPU)
    CUDA_CALLABLE_MEMBER void init(
        double* _state_vars, double* _intermediate_vars, 
        double* _global_params, double* _regional_params,
        int* _ext_int, bool* _ext_bool,
        int* _ext_int_shared, bool* _ext_bool_shared);

    CUDA_CALLABLE_MEMBER void step(
        double* _state_vars, double* _intermediate_vars,
        double* _global_params, double* _regional_params,
        double& tmp_globalinput,
        double* noise, long& noise_idx);

    CUDA_CALLABLE_MEMBER void post_bw_step(
        double* _state_vars, double* _intermediate_vars,
        int* _ext_int, bool* _ext_bool, 
        int* _ext_int_shared, bool* _ext_bool_shared,
        bool& restart,
        double* _global_params, double* _regional_params,
        int& ts_bold);

    CUDA_CALLABLE_MEMBER void restart(
        double* _state_vars, double* _intermediate_vars, 
        double* _global_params, double* _regional_params,
        int* _ext_int, bool* _ext_bool,
        int* _ext_int_shared, bool* _ext_bool_shared);

    CUDA_CALLABLE_MEMBER void post_integration(
        double ***state_vars_out, 
        int **global_out_int, bool **global_out_bool,
        double* _state_vars, double* _intermediate_vars, 
        int* _ext_int, bool* _ext_bool, 
        int* _ext_int_shared, bool* _ext_bool_shared,
        double** global_params, double** regional_params,
        double* _global_params, double* _regional_params,
        int& sim_idx, const int& nodes, int& j);

    // GPU interface methods
    void init_gpu(BWConstants bwc, bool force_reinit) override final {
        _init_gpu<${model_name}Model>(this, bwc, force_reinit);
    }

    void run_simulations_gpu(
        double * BOLD_ex_out, double * fc_trils_out, double * fcd_trils_out,
        double ** global_params, double ** regional_params, double * v_list,
        double ** SC, int * SC_indices, double * SC_dist) override final {
        _run_simulations_gpu<${model_name}Model>(
            BOLD_ex_out, fc_trils_out, fcd_trils_out, 
            global_params, regional_params, v_list,
            SC, SC_indices, SC_dist, this);
    }

% endif
    // CPU host methods (always required)
    void h_init(
        double* _state_vars, double* _intermediate_vars, 
        double* _global_params, double* _regional_params,
        int* _ext_int, bool* _ext_bool,
        int* _ext_int_shared, bool* _ext_bool_shared) override final;

    void h_step(
        double* _state_vars, double* _intermediate_vars,
        double* _global_params, double* _regional_params,
        double& tmp_globalinput,
        double* noise, long& noise_idx) override final;

    void _j_restart(
        double* _state_vars, double* _intermediate_vars, 
        double* _global_params, double* _regional_params,
        int* _ext_int, bool* _ext_bool,
        int* _ext_int_shared, bool* _ext_bool_shared) override final;

    % if has_post_bw_step:
    void _j_post_bw_step(
        double* _state_vars, double* _intermediate_vars,
        int* _ext_int, bool* _ext_bool,
        int* _ext_int_shared, bool* _ext_bool_shared,
        bool& restart,
        double* _global_params, double* _regional_params,
        int& ts_bold) override final;
    void h_post_bw_step(
        double** _state_vars, double** _intermediate_vars,
        int** _ext_int, bool** _ext_bool,
        int* _ext_int_shared, bool* _ext_bool_shared,
        bool& restart,
        double* _global_params, double** _regional_params,
        int& ts_bold) override final;
    % endif

    % if has_post_integration:
    void h_post_integration(
        double ***state_vars_out, 
        int **global_out_int, bool **global_out_bool,
        double* _state_vars, double* _intermediate_vars,
        int* _ext_int, bool* _ext_bool,
        int* _ext_int_shared, bool* _ext_bool_shared,
        double** global_params, double** regional_params,
        double* _global_params, double* _regional_params,
        int& sim_idx, const int& nodes, int& j) override final;
    % endif

    // CPU interface methods
    void init_cpu(bool force_reinit) override final {
        _init_cpu<${model_name}Model>(this, force_reinit);
    }

    void run_simulations_cpu(
        double * BOLD_ex_out, double * fc_trils_out, double * fcd_trils_out,
        double ** global_params, double ** regional_params, double * v_list,
        double ** SC, int * SC_indices, double * SC_dist) override final {
        _run_simulations_cpu<${model_name}Model>(
            BOLD_ex_out, fc_trils_out, fcd_trils_out, 
            global_params, regional_params, v_list,
            SC, SC_indices, SC_dist, this);
    }

    // Getter methods
    int get_n_state_vars() override final {
        return n_state_vars;
    }

    int get_n_global_out_bool() override final {
        return n_global_out_bool;
    }

    int get_n_global_out_int() override final {
        return n_global_out_int;
    }

    int get_n_global_params() override final {
        return n_global_params;
    }

    int get_n_regional_params() override final {
        return n_regional_params;
    }

    char * get_name() override final {
        return name;
    }
% if additional_methods:

    // Additional model-specific methods
${additional_methods}
% endif
};

#endif