# Autogenerated using:
# - Template: 'src/cubnm/sim/simgroup.py.mako'
# - Model definition: 'codegen/recipes/rwwex.yaml'
# Do not modify this autogenerated code. Instead modify template
# or model definition.
from .base import SimGroup
import sys
import logging
import numpy as np

logging.basicConfig(stream=sys.stdout, level=logging.WARNING)
logger = logging.getLogger(__name__)

class rWWExSimGroup(SimGroup):
    model_name = "rWWEx"
    global_param_names = ['G']
    regional_param_names = ['w', 'I0', 'sigma']
    state_names = ['x', 'r', 'S']
    sel_state_var = "r"
    n_noise = 1
    default_params = {
        "G": None,  # required
        "w": 0.9,
        "I0": 0.3,
        "sigma": 0.001,
    }

    def __init__(self, *args, **kwargs):
        r"""
        Group of reduced Wong Wang (excitatory) simulations that are executed in parallel.

        Parameters
        ---------
        *args, **kwargs:
            see :class:`cubnm.sim.SimGroup` for details

        Attributes
        ----------
        param_lists: :obj:`dict` of :obj:`np.ndarray`
            dictionary of parameter lists, including
                - ``'G'``: global coupling strength. Shape: (N_SIMS,)
                - ``'w'``: local excitatory recurrence. Shape: (N_SIMS, nodes)
                - ``'I0'``: external input current. Shape: (N_SIMS, nodes)
                - ``'sigma'``: noise amplitude. Shape: (N_SIMS, nodes)
                - ``'v'``: conduction velocity. Shape: (N_SIMS,)

        Equations
        ---------
        .. math::

            \begin{gather}
            x_i = w_i J^N S_i + G J^N \sum_j C_{ij} S_j + I_{0_{i}} \\
            r_i = \frac{a x_i - b}{1 - e^{-d(a x_i - b)}} \\
            \dot{S_i} = -\frac{S_i}{\tau_s} + (1 - S_i) \gamma r_i + {\sigma}_i \epsilon_i \\
            \end{gather}

        References
        ----------        
        * Deco et al. 2013 Journal of Neuroscience (10.1523/JNEUROSCI.1091-13.2013)
        """
        # parent init must be called after setting
        # model-specific attributes because
        # it sets .last_config which may include some
        # model-specific attributes
        super().__init__(*args, **kwargs)
