/* 
    Autogenerated based on 'src/ext/models.cu.mako' 
    and list of available models.
    Do not modify this autogenerated code. Instead modify template.
*/
#include "cubnm/models/jr.cuh"
#include "cubnm/models/kuramoto.cuh"
#include "cubnm/models/rww.cuh"
#include "cubnm/models/rwwex.cuh"
#include "cubnm/models/wc.cuh"

const std::vector<std::string> MODELS = {
    "JR",
    "Kuramoto",
    "rWW",
    "rWWEx",
    "WC",
};

// Helper function to copy constants to device
template<typename Model>
void copy_constants_to_device() {
    if (strcmp(Model::name, "JR") == 0) {
        CUDA_CHECK_RETURN(cudaMemcpyToSymbol(d_JRc, &Model::mc, sizeof(typename Model::Constants)));
        return;
    }
    if (strcmp(Model::name, "Kuramoto") == 0) {
        CUDA_CHECK_RETURN(cudaMemcpyToSymbol(d_Kuramotoc, &Model::mc, sizeof(typename Model::Constants)));
        return;
    }
    if (strcmp(Model::name, "rWW") == 0) {
        CUDA_CHECK_RETURN(cudaMemcpyToSymbol(d_rWWc, &Model::mc, sizeof(typename Model::Constants)));
        return;
    }
    if (strcmp(Model::name, "rWWEx") == 0) {
        CUDA_CHECK_RETURN(cudaMemcpyToSymbol(d_rWWExc, &Model::mc, sizeof(typename Model::Constants)));
        return;
    }
    if (strcmp(Model::name, "WC") == 0) {
        CUDA_CHECK_RETURN(cudaMemcpyToSymbol(d_WCc, &Model::mc, sizeof(typename Model::Constants)));
        return;
    }
}