/* 
    Autogenerated using:
    - Template: 'src/ext/models/model.cpp.mako'
    - Model definition: 'codegen/recipes/kuramoto.yaml'
    Do not modify this autogenerated code. Instead modify template
    or model definition.
*/
#include "cubnm/models/kuramoto.hpp"

// Static constants instance
KuramotoModel::Constants KuramotoModel::mc;

// Initialize constants based on dt
void KuramotoModel::init_constants(double dt) {
    mc.dt = dt; // integration step
    mc.sqrt_dt = sqrt(mc.dt); // square root of integration step
    mc.twopi = 2.0 * M_PI;
}
void KuramotoModel::set_conf(std::map<std::string, std::string> config_map) {
    set_base_conf(config_map);
    for (const auto& pair : config_map) {
        if (pair.first == "random_init_theta") {
            this->conf.random_init_theta = (bool)std::stoi(pair.second);
        }
    }
}

void KuramotoModel::h_init(
    double* _state_vars, double* _intermediate_vars,
    double* _global_params, double* _regional_params,
    int* _ext_int, bool* _ext_bool,
    int* _ext_int_shared, bool* _ext_bool_shared
) {
    // theta = init_theta
    _state_vars[0] = _regional_params[0];
}

void KuramotoModel::_j_restart(
    double* _state_vars, double* _intermediate_vars, 
    double* _global_params, double* _regional_params,
    int* _ext_int, bool* _ext_bool,
    int* _ext_int_shared, bool* _ext_bool_shared
) {
    // theta = init_theta
    _state_vars[0] = _regional_params[0];
}

void KuramotoModel::h_step(
        double* _state_vars, double* _intermediate_vars,
        double* _global_params, double* _regional_params,
        double& tmp_globalinput,
        double* noise, long& noise_idx
        ) {
    // theta_dot = omega + G * globalinput
    _intermediate_vars[0] = _regional_params[1] + _global_params[0] * tmp_globalinput;
    // theta = theta + dt * theta_dot + sqrt_dt * noise * sigma
    _state_vars[0] = _state_vars[0] + KuramotoModel::mc.dt * _intermediate_vars[0] + KuramotoModel::mc.sqrt_dt * noise[noise_idx] * _regional_params[2];
    // Phase reset
    // theta = fmod(theta, twopi)
    _state_vars[0] = fmod(_state_vars[0], KuramotoModel::mc.twopi);
}
