class Tx:
    def __init__(self, data: str, value: str, name: str = None):
        # Transaction input (data)
        self.data = data
        # Transaction value
        if isinstance(value, str):
            # Transform from hex string
            if value[0:2].lower() == "0x":
                self.value = int(value, base=16)
            else:
                self.value = int(value)
        else:
            self.value = int(value)
        # Name
        self.name = name

    def __repr__(self):
        return "Transaction {{Name: {name}, Data: {input}, Value: {value_eth:.2f} ether ({value})}}".format(
            name=self.name,
            input=self.data,
            value_eth=self.value / 10 ** 18,
            value=self.value,
        )
